/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#ifndef DGFLAGDEFS
#define DGFLAGDEFS

#define DG_HYPERBOLIC	1
#define DG_EUCLIDEAN	2
#define DG_SPHERICAL	4
#define DG_FINITE	8
#define DG_TRANSPOSED	16

#define DG_CONFORMALBALL	32
#define DG_UPPERHALFSPACE	64
#define DG_PROJECTIVEMODEL	128
#define DG_NUM_ATTR	8	/* the above are the attributes */

#define DG_METRIC_BITS		(DG_HYPERBOLIC | DG_EUCLIDEAN | DG_SPHERICAL)
#define DG_MODEL_BITS		(DG_CONFORMALBALL | DG_UPPERHALFSPACE | DG_PROJECTIVE)

/* for the matrix group entries */
#define DG_GENERAL	0x000	/* general invertible group: default */
#define DG_SPECIAL	0x100	/* determinant +/- 1 */
#define DG_ORTHOGONAL	0x200	/* M.Transpose(M) = d.I */
#define DG_PROJECTIVE	0x400	/* M.Transpose(M) = d.I */
#define DG_REAL		0x000	/* default is real */
#define DG_COMPLEX	0x800	/* default is real */

#define DG_TMP		0x10000

/* flag */
#define DG_CENTERCAM	1
#define DG_NEWDIRDOM	2	/* recompute dirdom */
#define DG_DRAWDIRDOM	4
#define DG_ZCULL	8	/* don't draw those behind the camera */
#define DG_DRAWCAM	0x10		
#define DG_DDBEAM	0x20	/* compute beamed dirichlet domain */
#define DG_DDSLICE	0x40	/* slice off cusps in dirichlet domain */
#define DG_DEBUG	0x100
#define DG_SAVEBIGLIST	0x200	/* does DiscGrpSave write out the group elements? */
#define DG_SAVEDIRDOM	0x400	/* does DiscGrpSave write out the dirichlet domain? */
#define DG_DRAWGEOM	0x800	/* draw other geometry? */
#define DG_NUM_DSPYATTR	5	/* zcull, cenercam, drawcam, drawdirdom, and drawgeom are externally settable */

/* constraint return values (only DG_CONSTRAINT_VALID is required) */
#define DG_CONSTRAINT_PRINT	1
#define DG_CONSTRAINT_TOOFAR	2
#define DG_CONSTRAINT_STORE	4
#define DG_CONSTRAINT_LONG	8
#define DG_CONSTRAINT_NEW	16
#define DG_CONSTRAINT_MAXLEN	32

/* bits in DiscGrpEl.attributes */
#define DGEL_IS_IDENTITY	0x1	/* need to mark the identity matrix */
#endif /*DGFLAGDEFS*/
