/* Copyright (c) 1992 The Geometry Center; University of Minnesota
    1300 South Second Street;  Minneapolis, MN  55454, USA;

This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Celeste Fowler, Charlie Gunn, Stuart Levy, Tamara Munzner, 
Mark Phillips */

#include "geom.h"
#include "geomclass.h"
#include "sphereP.h"

static char nameSphere[] = "sphere";

GeomClass *SphereClass = NULL;

int SpherePresent = 1;

char *SphereName()
{
  return nameSphere;
}

GeomClass *SphereMethods()
{
  if (SphereClass == NULL) {
    (void) InstMethods();
    SphereClass = GeomSubClassCreate("inst", "sphere");
    
    SphereClass->name = SphereName;
    SphereClass->methods = (GeomMethodsFunc *)SphereMethods;
    SphereClass->create = (GeomCreateFunc *)SphereCreate;
    SphereClass->fsave = (GeomFSaveFunc *)SphereFSave;
    SphereClass->fload = (GeomFLoadFunc *)SphereFLoad;
    SphereClass->export = NULL;
    SphereClass->import = NULL;
    SphereClass->unexport = NULL;
  }
  return SphereClass;
}
