#include <stdio.h>
#include <string.h>
#include "ooglutil.h"
#if defined(unix) || defined(__unix)
#include <sys/signal.h>
#endif /*unix*/

#if defined(unix) || defined(__unix) /* Don't try to compile for Windows */

#define FBUFSIZ 1024
#define INITSIZ 10

/*-----------------------------------------------------------------------
 * Function:	*ooglglob
 * Description:	C-shell globbing
 * Args:	*s: the string to glob
 * Returns:	pointer to array of pointers to expanded strings; ends
 *		   with NULL
 * Author:	mbp
 * Date:	Tue Aug 25 12:42:21 1992
 * Notes:	Invokes a subshell (/bin/csh) to do the work.
 *		Caller should free the returned value by
 *		first calling ooglblkfree() then free():
 *
 *		char **g;
 *		g = ooglglob(string);
 *		...
 *		ooglblkfree(g);
 *		free(g);
 */
char **ooglglob(char *s)
{
  FILE *fp;
  char cmd[FBUFSIZ];
  vvec vp;
  char *c;
  int status;
#ifdef SIGCHLD
	/* Avoid NeXT pclose() bug: don't catch subprocess' SIGCHLD */
  void (*oldsigchld)() = signal(SIGCHLD, SIG_DFL);
#endif

  sprintf(cmd, "/bin/csh -f -c \"echo %s\" 2>&-", s);
  fp = popen(cmd, "r");

  VVINIT(vp, char *, INITSIZ);
  while (!feof(fp))
    if ((c=ftoken(fp, 2)) != NULL) *VVAPPEND(vp,char*) = strdup(c);
  *VVAPPEND(vp,char*) = NULL;
  vvtrim(&vp);

  status = pclose(fp);
#ifdef SIGCHLD
  signal(SIGCHLD, oldsigchld);
#endif
  return VVEC(vp,char*);
}

ooglblkfree(av0)
     char **av0;
{
  register char **av = av0;
  while (*av)
    free(*av++);
}

#endif /*unix*/
