/*
   Siag, Scheme In A Grid
   Copyright (C) 1996, 1997  Ulric Eriksson <ulric@edu.stockholm.se>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "../siod/siod.h"
#include "../config.h"

#ifdef HAVE_ACOSH
static LISP wrap_acosh (LISP x)
{
  /*	if NFLONUMP(x) err("wta(1st) to acosh\n", x);
   */	return flocons(acosh(get_c_double(x)));
}
#endif

#ifdef HAVE_ASINH
static LISP wrap_asinh (LISP x)
{
	if NFLONUMP(x) err("wta(1st) to asinh\n", x);
	return flocons(asinh(get_c_double(x)));
}
#endif

static LISP wrap_ceil (LISP x)
{
	if NFLONUMP(x) err("wta(1st) to ceil\n", x);
	return flocons(ceil(get_c_double(x)));
}

static LISP wrap_cosh (LISP x)
{
	if NFLONUMP(x) err("wta(1st) to cosh\n", x);
	return flocons(cosh(get_c_double(x)));
}

static LISP wrap_fabs (LISP x)
{
	if NFLONUMP(x) err("wta(1st) to fabs\n", x);
	return flocons(fabs(get_c_double(x)));
}

static LISP wrap_floor (LISP x)
{
	if NFLONUMP(x) err("wta(1st) to floor\n", x);
	return flocons(floor(get_c_double(x)));
}

static LISP wrap_log10 (LISP x)
{
	if NFLONUMP(x) err("wta(1st) to log10\n", x);
	return flocons(log10(get_c_double(x)));
}

static LISP wrap_sinh (LISP x)
{
	if NFLONUMP(x) err("wta(1st) to sinh\n", x);
	return flocons(sinh(get_c_double(x)));
}

static LISP wrap_tanh (LISP x)
{
	if NFLONUMP(x) err("wta(1st) to tanh\n", x);
	return flocons(tanh(get_c_double(x)));
}

static LISP wrap_erf (LISP x)
{
	if NFLONUMP(x) err("wta(1st) to erf\n", x);
	return flocons(erf(get_c_double(x)));
}

static LISP wrap_erfc (LISP x)
{
	if NFLONUMP(x) err("wta(1st) to erfc\n", x);
	return flocons(erfc(get_c_double(x)));
}

static LISP wrap_j0 (LISP x)
{
	if NFLONUMP(x) err("wta(1st) to j0\n", x);
	return flocons(j0(get_c_double(x)));
}

static LISP wrap_j1 (LISP x)
{
	if NFLONUMP(x) err("wta(1st) to j1\n", x);
	return flocons(j1(get_c_double(x)));
}

static LISP wrap_lgamma (LISP x)
{
	if NFLONUMP(x) err("wta(1st) to lgamma\n", x);
	return flocons(lgamma(get_c_double(x)));
}

static LISP wrap_y0 (LISP x)
{
	if NFLONUMP(x) err("wta(1st) to y0\n", x);
	return flocons(y0(get_c_double(x)));
}

static LISP wrap_y1 (LISP x)
{
	if NFLONUMP(x) err("wta(1st) to y1\n", x);
	return flocons(y1(get_c_double(x)));
}

#ifdef HAVE_LOG1P
static LISP wrap_log1p (LISP x)
{
	if NFLONUMP(x) err("wta(1st) to log1p\n", x);
	return flocons(log1p(get_c_double(x)));
}
#endif

static LISP wrap_hypot(LISP x, LISP y)
{
	if NFLONUMP(x) err("wta(1st) to hypot\n", x);
	if NFLONUMP(y) err("wta(2nd) to hypot\n", y);
	return flocons(hypot(get_c_double(x), get_c_double(y)));
}

static LISP wrap_pow2 (LISP x)
{
	if NFLONUMP(x) err("wta(1st) to pow2\n", x);
	return flocons(pow(2.0, get_c_double(x)));
}

static LISP wrap_pow10 (LISP x)
{
	if NFLONUMP(x) err("wta(1st) to pow10\n", x);
	return flocons(pow(10.0, get_c_double(x)));
}

#ifdef HAVE_EXPM1
static LISP wrap_expm1 (LISP x)
{
	if NFLONUMP(x) err("wta(1st) to expm1\n", x);
	return flocons(expm1(get_c_double(x)));
}
#endif

#ifdef HAVE_CBRT
static LISP wrap_cbrt (LISP x)
{
	if NFLONUMP(x) err("wta(1st) to cbrt\n", x);
	return flocons(cbrt(get_c_double(x)));
}
#endif

#ifdef HAVE_DREM
static LISP wrap_drem(LISP x, LISP y)
{
	if NFLONUMP(x) err("wta(1st) to drem\n", x);
	if NFLONUMP(y) err("wta(2nd) to drem\n", y);
	return flocons(drem(get_c_double(x), get_c_double(y)));
}
#endif

/* ---
*/
void init_mathwrap(void)
{
#ifdef HAVE_ACOSH
	init_subr_1("acosh", wrap_acosh);
#endif
#ifdef HAVE_ASINH
	init_subr_1("asinh", wrap_asinh);
#endif	/* hpux */
	init_subr_1("ceil", wrap_ceil);
	init_subr_1("cosh", wrap_cosh);
	init_subr_1("fabs", wrap_fabs);
	init_subr_1("floor", wrap_floor);
	init_subr_1("log10", wrap_log10);
	init_subr_1("sinh", wrap_sinh);
	init_subr_1("tanh", wrap_tanh);
	init_subr_1("erf", wrap_erf);
	init_subr_1("erfc", wrap_erfc);
	init_subr_1("j0", wrap_j0);
	init_subr_1("j1", wrap_j1);
	init_subr_1("lgamma", wrap_lgamma);
	init_subr_1("y0", wrap_y0);
	init_subr_1("y1", wrap_y1);
#ifdef HAVE_LOG1P
	init_subr_1("log1p", wrap_log1p);
#endif
	init_subr_2("hypot", wrap_hypot);
	init_subr_1("pow2", wrap_pow2);
	init_subr_1("pow10", wrap_pow10);
#ifdef HAVE_EXPM1
	init_subr_1("expm1", wrap_expm1);
#endif
#ifdef HAVE_CBRT
	init_subr_1("cbrt", wrap_cbrt);
#endif
#ifdef HAVE_DREM
	init_subr_2("drem", wrap_drem);
#endif
}

