/*
   Copyright (C) 1999  Ulric Eriksson <ulric@edu.stockholm.se>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the Licence, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA.
 */

#ifndef s_CheckP_h
#define s_CheckP_h

#include "Check.h"
/* include superclass private header file */
#include <X11/CoreP.h>

/* define unique representation types not found in <X11/StringDefs.h> */

#define XtRCheckResource "CheckResource"

typedef struct {
    int empty;
} CheckClassPart;

typedef struct s_CheckClassRec {
    CoreClassPart	core_class;
    CheckClassPart	check_class;
} CheckClassRec;

extern CheckClassRec checkClassRec;

typedef struct {
    /* resources */
	XFontStruct *font;
	Boolean state;		/* True or False */
	SiagCheckStyle style;	/* Siag[Check|Radio][Win|Motif] */
	Widget start;		/* Where to start searching for siblings */
	Widget group;		/* First widget in group, None for check btn */
	char *label;		/* text to display or NULL */
	XtCallbackList callbacks;
    /* private state */
	GC gc;
	Pixmap cmon, cmoff, tbon, tboff, r16on, r16off, rmon, rmoff;
} CheckPart;

typedef struct s_CheckRec {
    CorePart		core;
    CheckPart	check;
} CheckRec;

#endif /* s_CheckP_h */
