/*
 *  Appindex browser - search
 *  Copyright (C) 1999 Martin Hinner <mhi@penguin.cz>
 *  $Id: search.c,v 0.5 1999/08/16 23:42:44 mhi Exp root $
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef HAVE_NCURSES_H
#include <ncurses.h>
#else
#include <curses.h>
#endif

#include "appindex.h"

#define STRING(x) ((x)?(x):"")

int search_no_mem;

struct app *
dup_app (struct app *app)
{
  struct app *a;

  a = (struct app *) malloc (sizeof (struct app));
  if (!a)
    return 0;

  a->name = app->name;
  a->stable = app->stable;
  a->devel = app->devel;
  a->license = app->license;
  a->homepage = app->homepage;
  a->download = app->download;
  a->changelog = app->changelog;
  a->deb = app->deb;
  a->rpm = app->rpm;
  a->link = app->link;
  a->oneliner = app->oneliner;
  a->description = app->description;
  a->dependancy = app->dependancy;
  a->author = app->author;
  a->coauthor = app->coauthor;
  a->day = app->day;
  a->month = app->month;
  a->year = app->year;
  a->cat = app->cat;
  a->priority = 0;
  a->next = 0;
  a->prev = 0;
  return a;
}

#ifndef __HAVE_STRCASESTR
char *
strcasestr (const char *s1, const char *s2)
{
  int l1, l2;

  l2 = strlen (s2);
  if (!l2)
    return (char *) s1;
  l1 = strlen (s1);
  while (l1 >= l2)
    {
      l1--;
      if (!strncasecmp (s1, s2, l2))
	return (char *) s1;
      s1++;
    }
  return NULL;
}
#endif

void
search_app (struct app *app, char *was, struct category *scat)
{
  struct app *a;
  int prio;

  prio = 0;

  if (strcasestr (STRING (app->stable), was))
    prio = 1;
  if (strcasestr (STRING (app->devel), was))
    prio = 1;
  if (strcasestr (STRING (app->license), was))
    prio = 1;

#if 0
  if (strstr (app->homepage, was))
    prio = 1;
  if (strstr (app->download, was))
    prio = 1;
  if (strstr (app->changelog, was))
    prio = 1;
  if (strstr (app->link, was))
    prio = 1;
  if (strstr (app->deb, was))
    prio = 1;
  if (strstr (app->rpm, was))
    prio = 1;
#endif

  if (strcasestr (STRING (app->oneliner), was))
    prio = 1;

  if (strcasestr (STRING (app->name), was))
    prio = 2;
  if (!strcasecmp (STRING (app->name), was))
    prio = 3;

  if (prio != 0)		/* Application matches */
    {
      a = dup_app (app);
      if (a)
	{
	  a->priority = prio;
	  add_app2cat (scat, a);
	  a->cat = app->cat;
	}
      else
	search_no_mem = 1;
    }
}

void
search_apps (struct app *apps, char *was, struct category *scat)
{
  struct app *a;

  a = apps;
  while (a)
    {
      search_app (a, was, scat);
      a = a->next;
    }
}

void
search_categories (char *was, struct category *scat)
{
  struct category *c;

  c = categories;
  while (c)
    {
      search_apps (c->apps, was, scat);
      c = c->next;
    }
}

void
do_search (char *substr)
{
  struct app *a, *an;
  struct category *scat;

  search_no_mem = 0;
  scat = (struct category *) malloc (sizeof (struct category));
  scat->name = "Search";
  scat->apps = 0;
  scat->prev = 0;
  scat->next = 0;
  scat->appno = 0;

  search_categories (substr, scat);

  if (search_no_mem)
    error ("Not enough memory, list may be incomplete.");
  if (!scat->apps)
    {
      error ("Pattern not found (press any key)");
      return;
    }

  scat->appno = relink_app (scat->apps);
  app_selection (scat->apps, scat->appno);

  a = scat->apps;
  free (scat);
  while (a)			/* Free all applications */
    {
      an = a->next;
      free (a);
      a = an;
    }
  scat = 0;
}

void
search ()
{
  unsigned char sstr[0x100];
  int c;
  int len;

  sstr[0] = 0;

  while (1)
    {
      len = strlen (sstr);
      attrset (COLOR_PAIR (CP_KEY));
      mvprintw (LINES - 1, 0, "/");
      attrset (COLOR_PAIR (CP_NORMAL));
      printw ("%-*.*s", COLS - 1, COLS - 1, sstr);
      move (LINES - 1, len + 1);
      refresh ();

      c = getch ();
      switch (c)
	{
	case KEY_BACKSPACE:
	case 8:
	  if (len == 0)
	    return;
	  sstr[len - 1] = 0;
	  break;
        case 7:
          return;            /* ^G cancels input */
        case 21:             /* ^U clears line */
          len = 0;
          sstr[0] = 0;
          break;
	case '\n':
	  if (len == 0)
	    return;
	  do_search (sstr);
	  return;
	default:
	  if (len < COLS - 1)
	    {
	      sstr[len] = c;
	      sstr[len + 1] = 0;
	    }
	  break;
	}
    }
}
