/* This file is part of Malaga, a system for Natural Language Analysis.
 * Copyright (C) 1995-1999 Bjoern Beutel
 *
 * Bjoern Beutel
 * Universitaet Erlangen-Nuernberg
 * Abteilung fuer Computerlinguistik
 * Bismarckstrasse 12
 * D-91054 Erlangen
 * e-mail: malaga@linguistik.uni-erlangen.de 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

/* description ==============================================================*/

/* Debugger functions. */

/* types ====================================================================*/

typedef enum /* debugger modes (set by set_debug_mode) */
{
  RUN_MODE, /* ignore breakpoints */
  GO_MODE, /* stop at breakpoints */
  WALK_MODE, /* stop at breakpoints and rule starts */
  NEXT_MODE, /* stop at new source lines; walk over subrules */
  STEP_MODE /* stop at new source lines */
} debug_mode_t;

/* variables ================================================================*/

GLOBAL bool_t in_debugger; /* TRUE iff in debugger loop. READ ONLY! */

/* functions ================================================================*/

extern void init_debugger (void (*my_print_rule) (void), 
			   command_t *my_debugger_commands[]);
/* Initialise the debugger module.
 * Pass a function <my_print_rule> printing the current rule, and commands
 * <my_debugger_commands> that can be invoked when debug mode is invoked. */

extern void terminate_debugger (void);
/* Terminate the run time environment. */

extern void set_debug_mode (debug_mode_t debug_mode, rule_sys_t *rule_sys);
/* Set debug mode <debug_mode> for <rule_sys>. */

/* commands =================================================================*/

extern command_t run_command; /* Execute rules in non-debugging mode. */

extern command_t go_command; /* Execute rules until breakpoint. */

extern command_t walk_command; /* Execute rules until different rule. */

extern command_t step_command; /* Execute rules until different line. */

extern command_t next_command; /* Execute rules until different line,
				* but jump over subrules. */

extern command_t print_command; /* Print the values of variables. */

extern command_t variables_command;
/* Generate variables file and start TCL program to display variables. */

extern command_t trace_command;
/* Print all active subrules and rules in reverse order. */

/* end of file ==============================================================*/
