/* Copyright (C) 1979-1996 TcX AB & Monty Program KB & Detron HB

   This software is distributed with NO WARRANTY OF ANY KIND.  No author or
   distributor accepts any responsibility for the consequences of using it, or
   for whether it serves any particular purpose or works at all, unless he or
   she says so in writing.  Refer to the Free Public License (the "License")
   for full details.
   Every copy of this file must include a copy of the License, normally in a
   plain ASCII text file named PUBLIC.	The License grants you the right to
   copy, modify and redistribute this file, but only under certain conditions
   described in the License.  Among other things, the License requires that
   the copyright notice and this notice be preserved on all copies. */

#include "heapdef.h"

/* Read next record with the same key */

int heap_rnext(HP_INFO *info, byte *record)
{
  byte *pos;
  HP_SHARE *share=info->s;
  DBUG_ENTER("heap_rnext");

  if (info->lastinx < 0)
    DBUG_RETURN(my_errno=HA_ERR_WRONG_INDEX);

  if (info->current_hash_ptr)
    pos= _hp_search_next(info,share->keydef+info->lastinx, info->lastkey,
			 info->current_hash_ptr);
  else
  {
    if (!info->current_ptr && (info->update & HA_STATE_NEXT_FOUND))
    {
      pos=0;					/* Read next after last */
      my_errno=HA_ERR_KEY_NOT_FOUND;
    }
    else if (!info->current_ptr && (info->update & HA_STATE_PREV_FOUND))
      pos= _hp_search(info,share->keydef+info->lastinx, info->lastkey, 0);
    else
      pos= _hp_search(info,share->keydef+info->lastinx, info->lastkey, 1);
  }

  if (!pos)
  {
    info->update=HA_STATE_NEXT_FOUND;		/* For heap_rprev */
    if (my_errno == HA_ERR_KEY_NOT_FOUND)
      my_errno=HA_ERR_END_OF_FILE;
    DBUG_RETURN(my_errno);
  }
  memcpy(record,pos,(size_t) share->reclength);
  info->update=HA_STATE_AKTIV | HA_STATE_NEXT_FOUND;
  DBUG_RETURN(0);
}
