#include <string.h>

#include "indexl.h"

static INLINE void
words_hash_totals_update(Hash_totals *h,int new,unsigned length) {

  if (new) {
    h->nw++;
    h->nc+=length;
    if (h->ms<length)
      h->ms=length;
  }

  h->nt++;

}


int
words_build_wordlist(Files *f,Words *w) {

  /* Change char width to unsigned */
  /* Check overflows ? */
  Datum *n,n1;
  Hash_totals ht={0},htf={0};
  Map m={0};
  Gen g;
  File *fp,*fpe;

  memset(&n1,0,sizeof(n1));
  for (fp=f->p.m1,fpe=f->p.me;fp<fpe-1;fp++) {

    if (!map_open(&m,fp->n,0))
      return 0;
    if (!map_get(&m,0,m.size))
      return 0;
    words_hash_totals_update(&htf,1,strlen(fp->n));

    for (;m.m<m.me;) {
      
      if (!str_to_token(&m,&g)) {
	err("str_to_token error in file %s\n",m.n);
	return 0;
      }
      if ((n=hash_get(&w->d,&g))) 
	memcpy(&n1,n,sizeof(n1));
      else
	n1.code.u=0;

      words_hash_totals_update(&ht,!n1.code.u,g.w);
      n1.code.u++;
      hash_put(&w->d,&g,&n1);
      
    }
    
    inf("File %s: %d total tokens parsed, %d unique\n",fp->n,ht.nt,ht.nw);
    if (!map_close(&m))
      return 0;

  }

  hash_put_totals(&w->d,&ht);
  hash_put_totals(&f->d,&htf);

  return 1;

}    

int
words_close(Words *w) {

  int i=1;

  if (!hash_close(&w->d))
    i=0;
  if (!map_close(&w->b))
    i=0;
  if (!map_close(&w->h))
    i=0;

  return i;

}

int
words_open(Words *w,const char *s,int new) {

  unsigned *u;

  if (!hash_open(&w->d,map_temp_str(".%s.index",s),new))
    return 0;
  if (!map_open(&w->b,map_temp_str(".%s.b",s),new))
    return 0;
  if (!map_open(&w->h,map_temp_str(".%s.huff",s),new))
    return 0;
  if (!new) {
    if (!map_get(&w->h,0,w->h.size))
      return 0;
    u=w->h.me;
    u--;
    w->he=(Huff *)w->h.m1+*u;
    if (!map_get(&w->h,0,w->h.size-sizeof(unsigned)))
      return 0;
  }

/*   if (!new)  */
/*     huff_build_from_codes(w); */

  return 1;

}
