/*  
 gdict.c Copyright Mike Hughes, 1999
 This code released under the GNU GPL. 
 Read the file COPYING for more information.
 Michael Bacarella wrote the networking code, 
 I modified it a bit to suit my purposes.
*/

/* 
 * Code cleanup by bert@biot.com 16-Feb-1999 
 * Definition truncate bugfix by Dave Finton 20-Mar-1999 
 * Definition truncate bugfix by Michael Bacarella 20-Mar-1999
 * Window resizing and cleanup by Iain (Nodatadj, EFNet) 23-Mar-1999
 */

#include <gtk/gtk.h>
#include <stdio.h>
#include <sys/socket.h>
#include <unistd.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <string.h>

/* globals */
GtkWidget *entry;
GtkWidget *defbox;
GtkWidget *label;

GtkWidget *find_focus(void);
void about (GtkWidget *widget, gpointer data);
void paste_text (GtkWidget *widget, gpointer data);
void copy_text (GtkWidget *widget, GtkWidget *entry);
void delete_event (GtkWidget *widget, GdkEvent *event, gpointer data);
void clearentry (GtkWidget *widget, gpointer data);
void lookup (GtkWidget *widget, gpointer data);

void about (GtkWidget *widget, gpointer data) {

	int chars = gtk_text_get_length(GTK_TEXT(defbox));
	char about_text[512];
          
	gtk_entry_set_text(GTK_ENTRY (entry), "");
	gtk_text_set_point(GTK_TEXT(defbox), 0);
	gtk_text_forward_delete(GTK_TEXT(defbox), chars);

	sprintf (about_text, "\n GDict version 0.6 released x/xx/99\n");
	sprintf (about_text, "%s Copyright (C) 1999 by Mike Hughes\n\n", about_text);
	sprintf (about_text, "%s Released under the GNU General Public License.\n\n", about_text);
	sprintf (about_text, "%s E-Mail: mfh@psilord.com\n", about_text);
	sprintf (about_text, "%s WWW: http://www.psilord.com/code\n\n", about_text);
	sprintf (about_text, "%s Check http://www.freshmeat.net or", about_text); 
	sprintf (about_text, "%s http://www.linuxapps.com for the latest version.", about_text);
 
	gtk_text_insert(GTK_TEXT(defbox),  NULL, NULL, NULL, g_strdup(about_text), strlen(about_text));
}


GtkWidget *find_focus(void) {

	if(GTK_WIDGET_HAS_FOCUS(entry)) {
		return(entry);
	}

	if(GTK_WIDGET_HAS_FOCUS(defbox)) {
		return(defbox);
	}

	return(NULL);
}


/* Paste text to box with focus */
void paste_text (GtkWidget *widget, gpointer data) {

	GtkWidget *focusbox;
	focusbox = find_focus();

	if(focusbox) {
		gtk_signal_emit_by_name(GTK_OBJECT(focusbox), "paste_clipboard");
	}
}


/* copy text from box with focus */
void copy_text (GtkWidget *widget, GtkWidget *entry) {

	GtkWidget *focusbox;
	focusbox = find_focus();

	if(focusbox) {
		gtk_signal_emit_by_name(GTK_OBJECT(focusbox), "copy_clipboard");
	}
}


/* Quit */
void delete_event (GtkWidget *widget, GdkEvent *event, gpointer data) {

	gtk_main_quit();
}


/* To clear both fields */
void clearentry (GtkWidget *widget, gpointer data) {

	/* 
	   This gets the length of the text in defbox, sets
	   the pointer to index 0, and then foward_deletes
	   the text.  Clears the entry box as well
	*/
	int chars = gtk_text_get_length(GTK_TEXT(defbox));
	
	gtk_entry_set_text(GTK_ENTRY (entry), "");
	gtk_text_set_point(GTK_TEXT(defbox), 0);
	gtk_text_forward_delete(GTK_TEXT(defbox), chars);
}


void lookup (GtkWidget *widget, gpointer data) {

	char *entry_text = gtk_entry_get_text(GTK_ENTRY(entry));
	int chars = gtk_text_get_length(GTK_TEXT(defbox));

	/* This networking code written by Michael Bacarella */
	struct  sockaddr_in      Sockaddr;
	int     err;
	int     sd;
	char    buffer[1023];
	char    buffer_bin[65535];
	char	temp[12];
	int     nchars;
	char 	eof = '\200';

	if (strlen(entry_text) == 0) {
		gtk_text_set_point(GTK_TEXT(defbox), 0);
		gtk_text_forward_delete(GTK_TEXT(defbox), chars);
		gtk_text_insert(GTK_TEXT(defbox),  NULL, NULL, NULL, "Nothing entered", 15);
		return;
	} 

	gtk_text_set_point(GTK_TEXT(defbox), 0);
	gtk_text_forward_delete(GTK_TEXT(defbox), chars);

	sd = socket (AF_INET, SOCK_STREAM, 0);
	if (sd == -1) {
		sprintf (buffer, "Socket error!");
		gtk_text_insert(GTK_TEXT(defbox),  NULL, NULL, NULL, g_strdup(buffer), strlen(buffer));
		return;
	}

	sprintf (buffer, "DEFINE %s\n", entry_text);

	Sockaddr.sin_family        = AF_INET;
	Sockaddr.sin_port          = htons(2627);
	Sockaddr.sin_addr.s_addr   = inet_addr ("128.52.39.7");     

	err = connect (sd, &Sockaddr, sizeof(Sockaddr));

	if (err != 0) {
		sprintf (buffer, "Could not connect to dictionary server!");
		gtk_text_insert(GTK_TEXT(defbox),  NULL, NULL, NULL, g_strdup(buffer), strlen(buffer));
		return;
	}

	err = send (sd, buffer, strlen(buffer), 0);

	if (err == 0) {
		sprintf (buffer, "Send error!");
	}

	strcpy (buffer_bin, "");  /* Clear the string */

	memset (buffer, 0, sizeof (buffer));
	sprintf(temp, "SPELLING 0");

	while (1) {
		if ((nchars = recv(sd, buffer, sizeof(buffer), 0) ) >= 1) {
			strncat (buffer_bin, buffer, nchars);
		}

		if ( strchr(buffer, eof) ) {
			break;
		}

		if ( strstr(buffer, temp) ) {
			break;
		}
	}

	gtk_text_set_point(GTK_TEXT(defbox), 0);
	gtk_text_insert(GTK_TEXT(defbox),  NULL, NULL, NULL, buffer_bin, -1);
}


int main (int argc, char *argv[]) {

	GtkWidget *window, *vbox;

	/* Nodatadj */
	GtkWidget *scroller;
	/* Nodatadj */

	GtkWidget *hbox;

	/* Menu widget declarations */
	GtkWidget *menu_bar;
	GtkWidget *file_menu, *file_item;
	 GtkWidget *define_menu, *quit_menu;
	GtkWidget *edit_menu, *edit_item; 
	 GtkWidget *copy_menu, *paste_menu;
	GtkWidget *help_menu, *help_item;
	 GtkWidget *about_menu; 

	GtkWidget *button;

	gtk_init (&argc, &argv);
	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title (GTK_WINDOW (window), "gdict");
	gtk_widget_set_usize (window, 500, 300);

	/* Closing the application calls this callback */
	gtk_signal_connect (GTK_OBJECT (window), "delete_event",
			    GTK_SIGNAL_FUNC (delete_event), NULL);

	vbox = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox);
	gtk_container_add (GTK_CONTAINER(window), vbox);

	file_menu = gtk_menu_new();
	quit_menu = gtk_menu_item_new_with_label("Quit");
	define_menu = gtk_menu_item_new_with_label("Define...");

	edit_menu = gtk_menu_new();
	copy_menu = gtk_menu_item_new_with_label("Copy");
	paste_menu = gtk_menu_item_new_with_label("Paste...");

	help_menu = gtk_menu_new();
	about_menu = gtk_menu_item_new_with_label("About...");

	gtk_menu_append( GTK_MENU(file_menu), define_menu);
	gtk_signal_connect_object( GTK_OBJECT(define_menu), "activate",
				   GTK_SIGNAL_FUNC(lookup), NULL);
	gtk_menu_append( GTK_MENU(file_menu), quit_menu);  
	gtk_signal_connect_object( GTK_OBJECT(quit_menu), "activate",
				   GTK_SIGNAL_FUNC(delete_event), NULL); 

	gtk_menu_append( GTK_MENU(edit_menu), copy_menu);
	gtk_signal_connect_object( GTK_OBJECT(copy_menu), "activate",
				   GTK_SIGNAL_FUNC(copy_text), NULL); 
	gtk_menu_append( GTK_MENU(edit_menu), paste_menu);
 	gtk_signal_connect_object( GTK_OBJECT(paste_menu), "activate", 
				   GTK_SIGNAL_FUNC(paste_text), NULL);

	gtk_menu_append( GTK_MENU(help_menu), about_menu);
	gtk_signal_connect_object( GTK_OBJECT(about_menu), "activate",
				   GTK_SIGNAL_FUNC(about), NULL);

	gtk_widget_show(define_menu);
	gtk_widget_show(quit_menu);

	gtk_widget_show(copy_menu);
	gtk_widget_show(paste_menu);

	gtk_widget_show(about_menu);

	menu_bar = gtk_menu_bar_new();
	
	/* Nodatadj */
	gtk_box_pack_start( GTK_BOX(vbox), menu_bar, FALSE,FALSE, 0);
	/* Nodatadj */

	gtk_widget_show(menu_bar);

	file_item = gtk_menu_item_new_with_label("File");
	edit_item = gtk_menu_item_new_with_label("Edit");
	help_item = gtk_menu_item_new_with_label("Help");

	gtk_menu_item_right_justify (GTK_MENU_ITEM(help_item));

	gtk_widget_show(file_item);
	gtk_widget_show(edit_item);
	gtk_widget_show(help_item);
	gtk_menu_item_set_submenu( GTK_MENU_ITEM(file_item), file_menu);
	gtk_menu_item_set_submenu( GTK_MENU_ITEM(edit_item), edit_menu);
	gtk_menu_item_set_submenu( GTK_MENU_ITEM(help_item), help_menu);

	gtk_menu_bar_append( GTK_MENU_BAR(menu_bar), file_item); 
	gtk_menu_bar_append( GTK_MENU_BAR(menu_bar), edit_item);
	gtk_menu_bar_append( GTK_MENU_BAR(menu_bar), help_item);

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox);

	/* Nodatadj */
	gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
	/* Nodatadj */

	gtk_container_border_width (GTK_CONTAINER (hbox), 5);

	entry = gtk_entry_new();
	gtk_widget_set_usize (entry, 490, 20);
	gtk_box_pack_start(GTK_BOX(hbox), entry, TRUE, TRUE, 0);
	gtk_signal_connect(GTK_OBJECT (entry), "activate",
			   GTK_SIGNAL_FUNC(lookup), NULL);
	gtk_widget_show(entry);
	
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox);

	/* Nodatadj */
	gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
	/* Nodatadj */
	gtk_container_border_width (GTK_CONTAINER (hbox), 5);

	button = gtk_button_new_with_label("   Clear    ");
	gtk_widget_show(button);
	
	/* Nodatadj */
	gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, FALSE, 0);
	gtk_signal_connect(GTK_OBJECT (button), "clicked",
			   GTK_SIGNAL_FUNC(clearentry), NULL);
	/* Nodatadj */
	
	label = gtk_label_new("Type word to define and press Enter");
	gtk_widget_show(label);
	gtk_box_pack_start(GTK_BOX(hbox), label, TRUE, TRUE, 0);
	gtk_widget_show(hbox);

	hbox = gtk_hbox_new(FALSE, 0);    

	/* Nodatadj */
	gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
	/* Nodatadj */

	gtk_container_border_width (GTK_CONTAINER (hbox), 5);
	gtk_widget_show(hbox);

        defbox = gtk_text_new (NULL, NULL);

	/* Nodatadj - I added this so that the scrollbar wouldn't run away
	   whenever the window was resized */
	scroller = gtk_scrolled_window_new(NULL,NULL);
	/* Nodatadj */

        gtk_text_set_editable (GTK_TEXT (defbox), FALSE);
        gtk_widget_set_usize (defbox, 490, 200);

	/* Nodatadj */
	gtk_container_add( GTK_CONTAINER( scroller ), defbox );
        gtk_box_pack_start(GTK_BOX(hbox), scroller, TRUE, TRUE, 0);
        gtk_widget_show(hbox);
        gtk_widget_show(defbox);
        gtk_widget_show(scroller);
	/* Nodatadj */
	
	gtk_widget_show(window);
	gtk_widget_grab_focus(entry);

	if (argv[1]) {
		gtk_entry_set_text(GTK_ENTRY (entry), argv[1]);
		lookup(NULL, NULL);
	}

	gtk_main ();

	return 0;
}
