/**************************************************************************** 
 ** File: dns.h
 **
 ** Author: Mike Borella
 **
 ** Comments: Structure of the first 12 bytes of DNS packets
 **
 ****************************************************************************/

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

typedef struct _DNSHdr
{
  u_int16_t dns_id;
#if defined (WORDS_BIGENDIAN)
  u_int16_t dns_fl_qr:1,
            dns_fl_opcode:4,
            dns_fl_aa:1,
            dns_fl_tc:1,
            dns_fl_rd:1,
            dns_fl_ra:1,
            dns_fl_zero:3,
            dns_fl_rcode:4;
#else
  u_int16_t dns_fl_rcode:4,
            dns_fl_zero:3,
            dns_fl_ra:1,
            dns_fl_rd:1,
            dns_fl_tc:1,
            dns_fl_aa:1,
            dns_fl_opcode:4,
            dns_fl_qr:1;
#endif
  u_int16_t dns_num_q;
  u_int16_t dns_num_ans;
  u_int16_t dns_num_auth;
  u_int16_t dns_num_add;
} DNSHdr;

void dump_dns(u_char *bp, int length);
