/*
  $Id: cfnl.h,v 1.4 1997/01/16 21:00:52 luik Exp $

  cfnl.h - header for omirrd config file variable (macro) handling.
  Copyright (C) 1996, Andreas Luik, <luik@pharao.s.bawue.de>.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef CFNL_H_INCLUDED
#define CFNL_H_INCLUDED

#ifdef	__cplusplus
extern "C" {
#endif

typedef struct CfNameList_ *CfNameList;

typedef struct CfNameList_ {	/* for making lists of strings */
    char *n_name;
    CfNameList n_next;
} CfNameListRec;

/* cfnl.c */
extern CfNameList cfAllocNameListEnt(char *name);
extern CfNameList cfAppendNameListEnt(CfNameList list, char *name);
extern void cfFreeNameListEnt(CfNameList list);
extern void cfFreeNameList(CfNameList list);
extern int cfMatchNameInList(char *name, CfNameList nl, int (*compar)(char *path, const char *pattern), char **targetnamep);
#ifdef DEBUG
extern void cfDebugNameList(char *prefix, CfNameList nl);
#endif

#ifdef	__cplusplus
}
#endif

#endif /* defined(CFNL_H_INCLUDED) */
