/*
  $Id: omirrd.h,v 1.9 1996/08/17 22:58:24 luik Exp $

  omirrd.h - general online mirror daemon definitions file.
  Copyright (C) 1996, Andreas Luik, <luik@pharao.s.bawue.de>.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef OMIRRD_H_INCLUDED
#define OMIRRD_H_INCLUDED

#include "mp.h"
#include "bio.h"
#include "lio.h"

#ifdef	__cplusplus
extern "C" {
#endif

#ifndef LOG_OMIRRD
#define LOG_OMIRRD LOG_DAEMON	/* default syslog(3) facility */
#endif

#ifndef PATH_OMIRRDCONF
#define PATH_OMIRRDCONF	"/etc/omirrd.conf" /* default config file name */
#endif

#ifndef PATH_STOREDIR
#define PATH_STOREDIR	"/var/omirrd" /* default redo-store directory */
#endif

/* Global input/output contexts.  */
extern BioContext bio_context;
extern LioContext lio_context;
extern MpContext mp_context;

/* Command line options */
extern unsigned char block_mode_flag; /* -b - set driver in block mode */
extern unsigned char clearbuf_flag; /* -c - clear ring buffer before reading */
extern unsigned long debug_flag; /* -d - enable debugging, run in foreground */
extern char *store_dir;

/* Some strings for error messages */
extern char *program_name;	/* name of current program (from argv[0]) */
extern char *program_version;	/* version of omirrd */
extern char *own_hostname;	/* official name of this host */
extern char *current_file_name;	/* name of file currently processed (or NULL) */
extern int current_line;	/* current line number in `current_file' or -1 */

#ifdef	__cplusplus
}
#endif

#endif /* defined(OMIRRD_H_INCLUDED) */
