// $Workfile: CS508LDR.CPP $  $Date: 2/26/98 11:38a $ - Copyright (C) 1996,1997 by jbm Electronics, Inc.

/*---------------------------------- REVISION HISTORY --------------------------------------------------------------------

  02/15/97 - (dl ) Began creating this file.

  05/02/97 - (dl ) Added informational error messages.

  02/20/98 - (kmm) Added support for embedded sangoma.
------------------------------------------------------------------------------------------------------------------------*/


#ifdef BOOTCODE
#pragma Code("romcode")
#pragma Cgroup("romgroup")
#pragma Cclass("romclass")
#endif


#include <memory.h>
#include <stdlib.h>

#ifdef OS2
  #include "os2defs.h"
# endif

#ifdef PLAT_LINUX
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/mman.h>
#include <stdio.h>
#include <asm/page.h>
#include <asm/io.h>
// #include <sys/io.h>
#include <sys/perm.h>
#endif

#include "cs508ldr.hpp"

#ifndef __NOCONIO
#include <iostream.h>
#endif


/*============================ Class cS508Loader Member Functions ============================================================*/


/*--------------------------------- Public member functions -------------------------------------------------------------*/


cS508Loader::cS508Loader (USHORT l_us_ioportaddr, ULONG l_ul_windowaddr, USHORT l_us_codebufferlen, UBYTE *l_ucp_codebuffer)
               :c_uc_SDLAcfg(ZERO),
                c_ucp_codebuffer(l_ucp_codebuffer),
                c_us_ioportaddr(l_us_ioportaddr),
                c_us_codebufferlen(l_us_codebufferlen),
                c_ul_windowphysaddr(l_ul_windowaddr)

  {
   /*****************************************************************\
   | Constructor - Allocate/Initialize resources  (Subroutine).      |
   |                                                                 |
   |  Entry parameters:  I/O port address, 8K window segment address,|
   |                     pointer to buffer containing code, and      |
   |                     length of code in buffer.                   |
   |                                                                 |
   |                     A successful construction also includes     |
   |                     getting a valid pointer to the start of the |
   |                     8K window. If the pointer is null, FAILURE. |
   |                                                                 |
   |           Returns:  Pointer to object if construction is        |
   |                     successful, else NULL.                      |
   |                                                                 |
   |  Globals affected:  None.                                       |
   |                                                                 |
   | Hardware affected:  None.                                       |
   |                                                                 |
   |  Calls:  Internal - None.                                       |
   |                                                                 |
   |          External - None.                                       |
   \*****************************************************************/

    c_ucA3_508NMIcode = new UBYTE [3];

    c_ucA3_508NMIcode[0] = 0xC3;                   // Store the 3 byte op code for the NMI (JMP 100)
    c_ucA3_508NMIcode[1] = 0x00;
    c_ucA3_508NMIcode[2] = 0x01;

    c_uc_windowsegaddr = (UBYTE)(c_ul_windowphysaddr >> 12); // Also need the most significant portion of the address

    // Now that the preliminary stuff is initialized, on to the driver.

    c_vp_windowbase = NULL;

#ifdef OS2
    APIRET  l_T_rv;  // Type of value returned by OS/2 CP API calls.


    struct _memmap l_S_ioctlparms;  // Parameter buffer passed via OS/2 IOCtl call.

    ULONG  l_ul_action,                               // Used by DosOpen (otherwise unused).
           l_ul_parmbuflen = sizeof(struct _memmap);  // Size of parameter buffer passed via OS/2 IOCtl.


    if (NO_ERROR != (l_T_rv = DosOpen("MEMACC$ ", &c_T_filehandle, &l_ul_action, 0L,                            // Try to open the HPC's
                                      FILE_NORMAL, OPEN_ACTION_OPEN_IF_EXISTS,                                  // OS/2 Physical Device
                                      OPEN_FLAGS_FAIL_ON_ERROR | OPEN_SHARE_DENYNONE | OPEN_ACCESS_READWRITE,   // Driver.
                                      0L                                                                        //
                                     )                                                                          //
                    )                                                                                           //
       )                                                                                                        //
      {                                                                                                         // If the open fails,
       #ifndef __NOCONIO
        cout << "Error: (s508) DosOpen (MEMACC) failed, OS/2 rc = " << dec << l_T_rv << endl << flush;          // post a message, the
       #endif
        return;
      }                                                                                                         // object doesn't construct.

//    cout << "Opened driver " << endl;
                                                                                                                //
    l_S_ioctlparms.address    = c_ul_windowphysaddr;                                                            // If the device opens,
    l_S_ioctlparms.length     = WINDOW_SIZE;                                                                    // issue the OS/2 IOCtl
    l_S_ioctlparms.returnAddr = 0L;                                                                             // request to set aside
                                                                                                                // an 8K memory window
    if (NO_ERROR != (l_T_rv = DosDevIOCtl(c_T_filehandle,  (ULONG)USRDEFIOCTL, (ULONG)eMEMMAP,                  //
                                          &l_S_ioctlparms, l_ul_parmbuflen,    &l_ul_parmbuflen,                //
                                          0L,              0L,                 NULL                             //
                                         )                                                                      //
                    )                                                                                           //
       )                                                                                                        //
      {                                                                                                         // If the IOCtl fails,
       #ifndef __NOCONIO
        cout << "Error: (s508) DosDevIOCtl(eMEMMAP) failed, OS/2 rc = " << dec << l_T_rv << endl;               // post a message, the memory
       #endif
        return;
      }                                                                                                         // window was unsuccessful and
    else
      {                                                                                                         // the object is not constructed.
        c_vp_windowbase = (void *)l_S_ioctlparms.returnAddr;                                                    // Need a pointer to the base of the memory window
      }
#endif
#ifdef PLAT_LINUX
                     int  mem_fd = open("/dev/mem", O_RDWR);
                     if (mem_fd < 0)
                     {
                         #ifndef __NOCONIO
                         cout << "Error: (s508) open failed, Linux fd = " << dec << mem_fd << endl;
                         #endif
                         return;
                     }
                     else
                     {
                         char *l_ul_dprphysaddr = new char[WINDOW_SIZE + (PAGE_SIZE-1)];

                         if (l_ul_dprphysaddr == 0)
                         {
                             #ifndef __NOCONIO
                             cout << "Error: (s508) new failed, Linux" <<  endl;
                             #endif
                             return;
                         }
                         else
                         {
                             if ((unsigned long)l_ul_dprphysaddr % PAGE_SIZE)
                             {
                                 l_ul_dprphysaddr += PAGE_SIZE -
                                      ((unsigned long) l_ul_dprphysaddr % PAGE_SIZE);
                             }

                             c_vp_windowbase = (void *) mmap(
                                          (caddr_t) l_ul_dprphysaddr,
                                          (size_t)WINDOW_SIZE, PROT_READ|PROT_WRITE,
                                          MAP_SHARED|MAP_FIXED, mem_fd,
                                          (off_t)(c_ul_windowphysaddr));

                             if (c_vp_windowbase < 0)
                             {
                                 #ifndef __NOCONIO
                                 cout << "Error: (s508) mmap failed, Linux"  << endl;
                                 #endif
                                 return;
                             }
                             else
                             {
                                 int   l_perms  = ioperm(c_us_ioportaddr, 3, 1);
                                 if (l_perms != 0)
                                 {
                                     #ifndef __NOCONIO
                                     cout << "Error: (s508) ioperm failed, Linux"  << endl;
                                     #endif
                                     return;
                                 }
                             }
                         }
                     }
#endif
#ifdef PLAT_GW50SERIES
        // provide some defaults (G80)
        c_vp_windowbase = (void *)0x01000000;
        c_us_ioportaddr = 0x390;
        c_uc_windowsegaddr = 0xa0; // Also need the most significant portion of the address
#endif
    return;
  }


cS508Loader::~cS508Loader(void)
  {
   /*****************************************************************\
   |  Destructor - Deallocates resources  (Subroutine).              |
   |                                                                 |
   |  Entry parameters:  DESTRUCTORS ACCEPT NO PARAMETERS BY         |
   |                     DEFINITION                                  |
   |                                                                 |
   |           Returns:  DESTRUCTORS RETURN VOID BY DEFINTION        |
   |                                                                 |
   |  Globals affected:  None.                                       |
   |                                                                 |
   | Hardware affected:  None.                                       |
   |                                                                 |
   |  Calls:  Internal - None.                                       |
   |                                                                 |
   |          External - None.                                       |
   \*****************************************************************/

    delete [] c_ucA3_508NMIcode;

    // Now on to closing the device driver.

#ifdef OS2
    APIRET  l_T_rv;  // Type of value returned by OS/2 CP API calls.

    if (NO_ERROR != (l_T_rv = DosClose(c_T_filehandle)))                            // driver is closed.
      {
       #ifndef __NOCONIO
        cout << "Error: (s508) DosClose (MEMACC) failed, OS/2 rc = " << dec << l_T_rv << endl;
       #endif
      }
    else
      {
//        cout << "Closed driver " << endl;
      }
#endif

  }


USHORT cS508Loader::DownLoadCode(void)
  {
   /*****************************************************************\
   |  DownLoadCode     - Main routine for loading the adapter.       |
   |                                                                 |
   |  Entry parameters:  None.                                       |
   |                                                                 |
   |           Returns:  Successfull command or not.                 |
   |                                                                 |
   |  Globals affected:  None.                                       |
   |                                                                 |
   | Hardware affected:  None.                                       |
   |                                                                 |
   |  Calls:  Internal - Write2IOPort,EraseAdapter,Copy2Adapter,     |
   |                     SetMemoryWindow                             |
   |                                                                 |
   |          External - None.                                       |
   \*****************************************************************/

    USHORT l_us_windowcfg = 0;

    if ( NULL == c_vp_windowbase )
        {
         #ifndef __NOCONIO
          cout << "Error: (s508) Could not access MEMACC." << endl << flush;
         #endif

          return NO_DRIVER_LOADED;   // Possibly no driver loaded.
        }


    if ( ADAPTER_SIGNATURE != ReadIOPort((USHORT)(c_us_ioportaddr + READ_ID)) )
        {
         #ifndef __NOCONIO
          cout << "Error: (s508) Adapter not found at I/O address" << setw(6) << setiosflags(ios::showbase) << hex << c_us_ioportaddr << "." << endl << flush;
         #endif

          return INVALID_IOPORT;     // Couldn't find adapter at this I/O port.
        }

    l_us_windowcfg = GetWindowAddress();

    if ( 0xFF == l_us_windowcfg )
        {
         #ifndef __NOCONIO
          cout << "Error: (s508) Invalid memory address." << endl << flush;
         #endif

          return INVALID_MEMORY_SEG;  // Possibly bad memory location for window.
        }

    Write2IOPort(l_us_windowcfg,(USHORT)(c_us_ioportaddr + WRITE_WCTL));                      // Initialize the adapter processor by
                                                                                    // telling it where to map the memory window.
    Write2IOPort(0x00,c_us_ioportaddr);                                             // Reset the processor.

    Write2IOPort(0x04,c_us_ioportaddr);                                             // Allow host access to the processor.

    EraseAdapter();

    Copy2Adapter(c_us_codebufferlen,c_ucp_codebuffer,CODE_BASE_ADDR);               // Copy buffer, containing code, to the
                                                                                    // adapter memory.

    Copy2Adapter(sizeof(c_ucA3_508NMIcode),c_ucA3_508NMIcode,ADAPTER_BASE_MEMORY);  // Copy JMP 0x100 code to adapter

    Copy2Adapter(1,&c_uc_SDLAcfg,0x10);

    Write2IOPort(0x07,(USHORT)(c_us_ioportaddr + WRITE_VCTL));

    Write2IOPort(0x06,c_us_ioportaddr);                                             // Tell processor on adapter to run
                                                                                    // run the frame relay code.
    SetMemoryWindow(PHYSADDR_CTL_BLOCK_OFF);

#ifdef OS2
    DosSleep(1L);                                                                   // Give the adapter time to get its code
#endif                                                                                    // running before doing anything else, like

    return COMMAND_SUCCESSFUL;                                                      // reading the code version. The IBM C Set++ compiler
  }                                                                                 // optimizer is a bit to agressive here.


/*--------------------------------- Private member functions -------------------------------------------------------------*/
void cS508Loader::EraseAdapter(void)
  {
   /*****************************************************************\
   |  EraseAdapter     - Copies a buffer of NULL to the adapter's    |
   |                     memory area for code. This area is from     |
   |                     address 0x00000 to 0x0FFFF.                 |
   |                                                                 |
   |  Entry parameters:  None.                                       |
   |                                                                 |
   |           Returns:  None.                                       |
   |                                                                 |
   |  Globals affected:  None.                                       |
   |                                                                 |
   | Hardware affected:  None.                                       |
   |                                                                 |
   |  Calls:  Internal - Copy2Adapter                                |
   |                                                                 |
   |          External - Memset.                                     |
   \*****************************************************************/

    ULONG l_ul_address;

    UBYTE *l_ucp_nullbuf = new UBYTE [ADAPTER_SEG_SIZE];

    memset(l_ucp_nullbuf,(int) 0,ADAPTER_SEG_SIZE);

    for ( l_ul_address = 0; l_ul_address < 0xFFFF; l_ul_address += ADAPTER_SEG_SIZE)
        {
          Copy2Adapter(ADAPTER_SEG_SIZE,l_ucp_nullbuf,l_ul_address);
        }

    delete [] l_ucp_nullbuf;

    return;
  }


void cS508Loader::Copy2Adapter(USHORT l_us_bufferlen, UBYTE *l_ucp_buffer, ULONG l_ul_destptr)
  {
   /*****************************************************************\
   |  Copy2Adapter     - Write a buffer to the specified memory      |
   |                     address on the adapter.                     |
   |                                                                 |
   |  Entry parameters:  Buffer length, ptr to buffer, destination   |
   |                     address.                                    |
   |                                                                 |
   |           Returns:  None.                                       |
   |                                                                 |
   |  Globals affected:  None.                                       |
   |                                                                 |
   | Hardware affected:  s508.                                       |
   |                                                                 |
   |  Calls:  Internal - SetMemoryWindow,FormatPtr2MemoryWindow.     |
   |                                                                 |
   |          External - Memcpy.                                     |
   \*****************************************************************/

    USHORT l_us_bytesleftinsegment,
           l_us_totalbyteswritten = ZERO;

    ULONG  l_ul_destoffset = l_ul_destptr;

    do
        {
          SetMemoryWindow(l_ul_destoffset);

          if ( ((l_ul_destoffset % 0x2000) + l_us_bufferlen) > 0x2000 )                    // Calculate how much message is left to write
              {                                                                            // in this 8K segment. If the remainder of the
                l_us_bytesleftinsegment = (USHORT)( 0x2000 - ( l_ul_destoffset % 0x2000 ));// segment is greater than the rest of the message
              }                                                                            // length, copy only up to the end of this segment.
          else                                                                             //
              {                                                                            //
                l_us_bytesleftinsegment = l_us_bufferlen;                                  // Otherwise, copy the whole (or remainder) of the
              }                                                                            // message.

          memcpy((UBYTE *)FormatPtr2MemoryWindow(l_ul_destoffset),l_ucp_buffer+l_us_totalbyteswritten,l_us_bytesleftinsegment);

          l_us_totalbyteswritten += l_us_bytesleftinsegment;
          l_ul_destoffset += l_us_bytesleftinsegment;                                      // Adjust the pointer since we've written some data.
          l_us_bufferlen -= l_us_bytesleftinsegment;

        } while ( 0 != l_us_bufferlen );

    return;
  }


USHORT cS508Loader::GetWindowAddress(void)
  {
   /*****************************************************************\
   |  GetWindowAddress - Calculate the byte to write to the WCTL     |
   |                     register to tell the adapter processor      |
   |                     where to map the window in the host memory. |
   |                                                                 |
   |  Entry parameters:  None.                                       |
   |                                                                 |
   |           Returns:  Byte value to write to the WCTL register.   |
   |                                                                 |
   |  Globals affected:  None.                                       |
   |                                                                 |
   | Hardware affected:  None.                                       |
   |                                                                 |
   |  Calls:  Internal - None.                                       |
   |                                                                 |
   |          External - None.                                       |
   \*****************************************************************/


    USHORT l_us_windowcfg = ZERO,
           l_us_memseg,
           l_us_window;

    UBYTE l_uc_memsegch,           // the character to be written to port
                                   // (base address + 1) to set the memory segment address
          l_uc_windowch;           // the character to be written to port
                                   // (base address + 1) to set the PC memory window


    l_us_memseg = (USHORT)((c_uc_windowsegaddr & 0xF0) * 0x100);
    l_us_window = (USHORT)(c_uc_windowsegaddr & 0x0F);

    switch (l_us_memseg)          // set the memory segment
      {
        case 0xA000: {            // memory segment A
                       l_uc_memsegch = SEG_A;
                       break;
                     }
        case 0xD000: {            // memory segment B
                       l_uc_memsegch = SEG_D;
                       break;
                     }

        case 0xC000: {            // memory segment C
                       l_uc_memsegch = SEG_C;
                       break;
                     }

        case 0xE000: {            // memory segment E
                       l_uc_memsegch = SEG_E;
                       break;
                     }

          default: return 0xFF;   // an invalid memory segment was defined, do something
                     //break;
      }

    switch (l_us_window)          // set the PC window address
      {
        case 0x00: {              // memory window 0x0000 to 0x1FFF
                     l_uc_windowch = PC_OFF_00_1F;
                     break;
                   }
        case 0x02: {              // memory window 0x2000 to 0x3FFF
                     l_uc_windowch = PC_OFF_20_3F;
                     break;
                   }
        case 0x04: {              // memory window 0x4000 to 0x5FFF
                     l_uc_windowch = PC_OFF_40_5F;
                     break;
                   }
        case 0x06: {              // memory window 0x6000 to 0x7FFF
                     l_uc_windowch = PC_OFF_60_7F;
                     break;
                   }
        case 0x08: {              // memory window 0x8000 to 0x9FFF
                     l_uc_windowch = PC_OFF_80_9F;
                     break;
                   }
        case 0x0A: {              // memory window 0xA000 to 0xBFFF
                     l_uc_windowch = PC_OFF_A0_BF;
                     break;
                   }
        case 0x0C: {              // memory window 0xC000 to 0xDFFF
                     l_uc_windowch = PC_OFF_C0_DF;
                     break;
                   }

          default: return 0xFF;   // an invalid memory window was defined, do something
                   //break;

      }

    l_us_windowcfg = (USHORT)(l_uc_memsegch | l_uc_windowch);

    return l_us_windowcfg;
  }


void cS508Loader::SetMemoryWindow(ULONG l_ul_ptraddress)
  {
   /*****************************************************************\
   |  SetMemoryWindow  - Moves the focus of the 8K memory window     |
   |                     to another part of the memory on the        |
   |                     adapter. Think of the adapter memory as     |
   |                     sliding under the 8K PC memory window.      |
   |                                                                 |
   |  Entry parameters:  Physical adapter address to which focus     |
   |                     should be moved.                            |
   |                                                                 |
   |           Returns:  None.                                       |
   |                                                                 |
   |  Globals affected:  None.                                       |
   |                                                                 |
   | Hardware affected:  s508 port.                                  |
   |                                                                 |
   |  Calls:  Internal - None.                                       |
   |                                                                 |
   |          External - DosDevIOCtl.                                |
   \*****************************************************************/

#ifdef OS2
    APIRET l_T_rv;   // Type of value returned by OS/2 CP API calls.

    struct _iopacket l_S_ioctlparms;  // Parameter buffer passed via OS/2 IOCtl call

    ULONG l_ul_parmbuflen = sizeof(struct _iopacket);   // Size of parameter buffer passed via OS/2 IOCtl

    l_S_ioctlparms.address = c_us_ioportaddr + WRITE_VCTL;
    l_S_ioctlparms.data    = (ULONG)((l_ul_ptraddress >> 13) & 0xFF);

    if ( NO_ERROR != (l_T_rv = DosDevIOCtl(c_T_filehandle,  (ULONG)USRDEFIOCTL, (ULONG)eBPOKEIO,
                                           &l_S_ioctlparms, l_ul_parmbuflen,    &l_ul_parmbuflen,
                                           0L,              0L,                 NULL
                                          )
                     )
        )
      {
//        cout << "Unable to adjust memory window " << dec << l_T_rv;
      }
#endif
#ifdef PLAT_LINUX
     outb(((l_ul_ptraddress >> 13) & 0xFF), c_us_ioportaddr + WRITE_VCTL);
#endif
#ifdef PLAT_GW50SERIES
     _outb(c_us_ioportaddr + WRITE_VCTL, ((l_ul_ptraddress >> 13) & 0xFF));
#endif

    return;

  }


void cS508Loader::Write2IOPort(USHORT l_us_value, USHORT l_us_portaddress)
  {
   /*****************************************************************\
   |  Write2IOPort     - Write a value to a specified I/O Port       |
   |                     register.                                   |
   |                                                                 |
   |  Entry parameters:  Value to write and I/O Port address.        |
   |                                                                 |
   |           Returns:  None.                                       |
   |                                                                 |
   |  Globals affected:  None.                                       |
   |                                                                 |
   | Hardware affected:  s508 port.                                  |
   |                                                                 |
   |  Calls:  Internal - None.                                       |
   |                                                                 |
   |          External - DosDevIOCtl.                                |
   \*****************************************************************/

#ifdef OS2
    APIRET l_T_rv;   // Type of value returned by OS/2 CP API calls.

    struct _iopacket l_S_ioctlparms;  // Parameter buffer passed via OS/2 IOCtl call

    ULONG l_ul_parmbuflen = sizeof(struct _iopacket);   // Size of parameter buffer passed via OS/2 IOCtl

    l_S_ioctlparms.address = l_us_portaddress;
    l_S_ioctlparms.data    = l_us_value;

    if ( NO_ERROR != (l_T_rv = DosDevIOCtl(c_T_filehandle,  (ULONG)USRDEFIOCTL, (ULONG)eBPOKEIO,
                                           &l_S_ioctlparms, l_ul_parmbuflen,    &l_ul_parmbuflen,
                                           0L,              0L,                 NULL
                                          )
                     )
        )
      {
//        cout << "Write 2 I/O Port command failed." << dec << l_T_rv;
      }
#endif
#ifdef PLAT_LINUX
     outb((l_us_value & 0x00ff), l_us_portaddress );
#endif
#ifdef PLAT_GW50SERIES
     _outb(l_us_portaddress, (l_us_value & 0x00ff));
#endif
    return;

  }


UBYTE cS508Loader::ReadIOPort(USHORT l_us_portaddress)
  {
   /*****************************************************************\
   |  IsInfoFrameQueued - Checks the adapter for a received I-frame  |
   |                      by reading the base I/O port register.     |
   |                                                                 |
   |  Entry parameters:  None.                                       |
   |                                                                 |
   |           Returns:  True if a I-frame received, else False.     |
   |                                                                 |
   |  Globals affected:  None.                                       |
   |                                                                 |
   | Hardware affected:  s508 port.                                  |
   |                                                                 |
   |  Calls:  Internal - None.                                       |
   |                                                                 |
   |          External - DosDevIOCtl.                                |
   \*****************************************************************/

#ifdef OS2
    APIRET l_T_rv;   // Type of value returned by OS/2 CP API calls.

    struct _iopacket l_S_ioctlparms;  // Parameter buffer passed via OS/2 IOCtl call

    ULONG l_ul_parmbuflen = sizeof(struct _iopacket);  // Size of parameter buffer passed via OS/2 IOCtl

    l_S_ioctlparms.address = l_us_portaddress;         // I/O base port register
    l_S_ioctlparms.data    = 0x00;                     // clear this variable

    if ( NO_ERROR != (l_T_rv = DosDevIOCtl(c_T_filehandle,  (ULONG)USRDEFIOCTL, (ULONG)eBPEEKIO,
                                           &l_S_ioctlparms, l_ul_parmbuflen,    &l_ul_parmbuflen,
                                           0L,              0L,                 NULL
                                          )
                     )
        )
      {
//        cout << "Unable to read I/O base port register " << dec << l_T_rv;
      }

    return (UBYTE)l_S_ioctlparms.data;
#endif
#ifdef PLAT_LINUX
    UBYTE    l_ret_val = inb (l_us_portaddress);
    return (l_ret_val);
#endif
#ifdef PLAT_GW50SERIES
    UBYTE    l_ret_val = _inb (l_us_portaddress);
    return (l_ret_val);
#endif
  }

#ifdef BOOTCODE
#pragma Code()
#endif



// END END END END END END END END END END END END END END END END END END END END END END END END END END END END END END END END END
//
