#ifndef _WMPPXP_X_H
#define _WMPPXP_X_H

/* Parts pixmap coordinates */
#define IO_BAR_X    1
#define IO_BAR_Y    1
#define IO_BAR_WIDTH  47
#define IO_BAR_HEIGHT 5

#define NUM_START_X 1
#define NUM_START_Y 7
#define NUM_WIDTH  5
#define NUM_HEIGHT 7

#define CON_X 1
#define CON_Y 15
#define CON_WIDTH  17
#define CON_HEIGHT 8

#define DIS_X 19
#define DIS_Y 15
#define DIS_WIDTH  17
#define DIS_HEIGHT 8

#define BUTTON_WIDTH  11
#define BUTTON_HEIGHT 10

#define BTN_CON_OFF_X 1
#define BTN_CON_OFF_Y 24
#define BTN_CON_ON_X  1
#define BTN_CON_ON_Y  35

#define BTN_DIS_OFF_X 13
#define BTN_DIS_OFF_Y 24
#define BTN_DIS_ON_X  13
#define BTN_DIS_ON_Y  35

#define BTN_PROP_OFF_X 25
#define BTN_PROP_OFF_Y 24
#define BTN_PROP_ON_X  25
#define BTN_PROP_ON_Y  35

/* wmppxp definition */
#define NAME  "wmppxp"
#define CLASS "WMPPXP"

typedef enum {
  FALSE,
  TRUE
} BOOL;

typedef struct {
  int left;
  int top;
  int right;
  int bottom;
} Rect;

typedef struct {
  Pixmap        pixmap;
  Pixmap        mask;
  XpmAttributes attr;
} XpmIcon;

/* Global variables */
Display *display;
BOOL IsConnect;
Rect rgnCon, rgnDis, rgnPrp;

/* Function prototype */
void CreateXWindow( int argc, char *argv[] );
void CreateImageFromPixmap();
void RedrawWindow();
void RedrawInMeter();
void RedrawOutMeter();
BOOL PtInButton( Rect rect, int x, int y );
void ShowXpm( int sx, int xy, int swidth, int sheight, int dx, int dy );
void ShowRunningTimeInArea( int timeDiff );

#endif    /* #ifndef _WMPPXP_X_H */
