/*  Player.h
 *  Copyright (C) 1998 Andy Lo A Foe <andy@alsa-project.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#ifndef __CorePlayer_h__
#define __CorePlayer_h__
#include <stdio.h>
#include <pthread.h>
#include <gtk/gtk.h>
#include <semaphore.h>
#include "SampleBuffer.h"
#include "AlsaDAC.h"
#include "AlsaSubscriber.h"
#include "input_plugin.h"

// Tunable parameters

#define BUF_SIZE (10240) // Size of a single ringbuffer partition
#define NR_BUF 64	// Number of partitions in ringbuffer 
#define NR_CBUF 16	// Number of partition to read ahead	

typedef struct _sample_buf
{
	int start;
	_sample_buf *next, *prev;
	SampleBuffer *buf;
} sample_buf;


class CorePlayer // Much more abstraction to come, well maybe not
{
 private:
	char file_path[1024]; 
	int total_frames;
	int write_buf_changed;
	int read_direction;
	int frames_in_buffer;
	int jumped;
	int jump_point;
	int last_read;
	bool streaming;
	int repitched;
	int new_frame_number;
	float pitch_point;
	float pitch;
	float pitch_multi;
	bool producing;
	AlsaDAC *dac;
	AlsaSubscriber *sub;
	AlsaSubscriber *test_sub;

	// INPUT plugin stuff
	input_object *the_object;
	input_plugin *plugin; // Pointer to the current plugin
	
	pthread_t producer_thread;
	pthread_mutex_t player_mutex;
	pthread_mutex_t counter_mutex;
	pthread_mutex_t thread_mutex;
	sample_buf *buffer;
	sample_buf *read_buf, *write_buf, *new_write_buf;
	int FrameSeek(int);
	int AvailableBuffers();
	void ResetBuffer();
	void SetSpeedMulti(float multi) { pitch_multi = multi; }
	void update_pitch();
	bool Open();
	void Close();
 	static void producer_func(void *data);
	static bool streamer_func(void *, void *, int);
	int pcm_worker(sample_buf *dest, int start, int lin=0);
	int Read32(void *, int);
	int SetDirection(int dir);
	int GetDirection() { return read_direction; }
 public:
	static int plugin_count; // Number of registered plugins
	static input_plugin plugins[32]; // Be very optimistic, and save too :)

	CorePlayer(AlsaDAC *dac=NULL);
	~CorePlayer();
	AlsaDAC *GetDAC() { return dac; }
	int RegisterPlugin(input_plugin *the_plugin);
	int SetSpeed(float val);
	float GetSpeed();
	void SetFile(const char *path);
	int GetPosition();
	unsigned long GetCurrentTime(int frame=-1);
	int GetStreamInfo(stream_info *info);
	int GetFrames();
	int GetSampleRate();
	// This one is temporary
	int GetLatency() { if (dac) return dac->GetLatency(); else return 0; }
	// This one should be private
	
	bool Start(int reset=1);
	void Stop(int streamer=1);
	int Seek(int pos);
	
	int IsActive() { return streaming; }	
	int IsPlaying() { return producing; }
};


#endif
