/*  stereoscope.c
 *  Copyright (C) 1998 Andy Lo A Foe <arloafoe@cs.vu.nl>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 
#include <pthread.h>
#include <dirent.h>
#include <sys/stat.h>
#include <gtk/gtk.h>
#include <sys/time.h>
#include <time.h>   
#include <math.h>
#include <stdio.h>
#include <unistd.h>
#include <malloc.h>
#include <string.h>
#include <assert.h>
#include "scope_config.h"

#define GRID_LINES

static char actEql[257];
static char oldEql[257];
static char actEqr[257];
static char oldEqr[257];
static GdkImage *imagel = NULL;
static GdkImage *imager = NULL;
static GtkWidget *scope_win = NULL;
static int ready_state = 0;
static pthread_t stereoscope_thread;
static pthread_mutex_t stereoscope_mutex;
static int is_init = 0;
static int running = 0;

static void stereoscope_hide();

static const int default_colors[] = {
    10, 20, 30,
    230, 230, 230
};


static void stereoscope_set_data(void *audio_data, int size)
{
	short *sound = (short *)audio_data;

	int i;	
	if (running && sound && size >=256) {
		char *newsetl = actEql;
		char *newsetr = actEqr;	
        	int bufsize = size/256;
		for (i=0; i < 256; i++) {
			*newsetl++=(char)(((short)(*(sound))) >> 10);
			*newsetr++=(char)(((short)(*(sound+1)) >> 10));
			sound += bufsize;
		}
	}
}

#define STEREOSCOPE_DOLOOP() \
while (running) { \
	int w, i;\
	for (w=0; w < 256 * 64; w++) { \
		bitsr[w] = bg_color.pixel; \
		bitsl[w] = bg_color.pixel; \
	} \
	memcpy(oldsetl,newsetl,256); \
	memcpy(oldsetr,newsetr,256); \
	for (i=0; i < 256; i++) { \
		foo = oldEql[i]; \
		bar = (i + ((foo+32) << 8 )); \
		if ((bar > 0) && (bar < (256 * 64))) { \
			loc = bitsl + bar; \
			if (foo < 0) { \
				for (h = 0; h <= (-foo); h++) { \
					*loc = colEql[h]; \
					loc+=256; \
				} \
			} else { \
				for (h = 0; h <= foo; h++) { \
					*loc = colEql[h]; \
					loc-=256; \
				} \
			} \
		} \
	} \
	for (i=0; i < 256; i++) { \
		foo = oldEqr[i]; \
		bar = (i + ((foo+32) << 8 )); \
		if ((bar > 0) && (bar < (256 * 64))) { \
			loc = bitsr + bar; \
			if (foo < 0) { \
				for (h = 0; h <= (-foo); h++) { \
					*loc = colEqr[h]; \
					loc+=256; \
				} \
			} else { \
				for (h = 0; h <= foo; h++) { \
					*loc = colEqr[h]; \
					loc-=256; \
				} \
			} \
		} \
	} \
	for (i=16; i < 64; i+= 16) { \
		for (h = 0; h < 256; h+=2) { \
			bitsr[(i << 8) + h] = bitsl[(i << 8) + h] = raster_color.pixel; \
		} \
	} \
	for (h = 0; h < 256; h+=2) { \
		bitsl[(64 << 8) + h] = raster_color.pixel; \
	} \
	for (i=16; i < 256; i+= 16) { \
		for (h = 0; h < 64; h+=2) { \
			bitsr[i + (h << 8)] = bitsl[i + (h << 8)] = raster_color.pixel; \
		} \
	} \
	GDK_THREADS_ENTER(); \
	gdk_draw_image(win,gc,imagel,0,0,0,0,-1,-1); \
	gdk_draw_image(win,gc,imager,0,0,0,64,-1,-1); \
	gdk_flush(); \
	GDK_THREADS_LEAVE(); \
	dosleep(SCOPE_SLEEP); \
}

static void stereoscope32(void *data)
{
	guint32 *loc;
	gint foo;
	char *oldsetl = oldEql;
	char *newsetl = actEql;
	char *oldsetr = oldEqr;
	char *newsetr = actEqr;
	guint32 *bitsr, *bitsl;
    int bar;  
	guint32 colEqr[65];
	guint32 colEql[65];
	int i, h;
	GdkWindow *win;
	GdkColormap *c;
	GdkVisual *v;
	GdkGC *gc;
	GdkColor raster_color;
	GdkColor bg_color;
	
	win = (GdkWindow *)data;
	GDK_THREADS_ENTER();
	c = gdk_window_get_colormap(win);
	gc = gdk_gc_new(win);
	v = gdk_window_get_visual(win);

	for (i = 0; i < 16; i++) {
		GdkColor color;
		color.red = (i*8) << 8;
		color.green = 255 << 8;
		color.blue = 0;
		gdk_color_alloc(c, &color);
		colEql[i] = color.pixel;
		colEqr[i] = color.pixel;
		color.red = 255 << 8;
		color.green = ((31 - i) * 8) << 8;
		color.blue = 0;
		gdk_color_alloc(c, &color);
		colEql[i + 16] = color.pixel;
		colEqr[i + 16] = color.pixel;
	}

	raster_color.red = 40 << 8;
	raster_color.green = 75 << 8;
	raster_color.blue = 0;
	gdk_color_alloc(c, &raster_color);

	
	// Create render image
	if (imagel) {
		gdk_image_destroy(imagel);	
		imagel = NULL;
	}
	imagel = gdk_image_new(GDK_IMAGE_FASTEST, v, 256, 64);
	if (imager) {
                gdk_image_destroy(imager);
                imager = NULL;
        }
        imager = gdk_image_new(GDK_IMAGE_FASTEST, v, 256, 64);
	
    bg_color.red = SCOPE_BG_RED << 8;
    bg_color.green = SCOPE_BG_GREEN << 8;
    bg_color.blue = SCOPE_BG_BLUE << 8;        
	gdk_color_alloc(c, &bg_color); 
	GDK_THREADS_LEAVE();
	
	assert(imager);
	assert(imagel);
	assert(imagel->bpp == 4);
	
	bitsr = (guint32 *)imager->mem;	
	bitsl = (guint32 *)imagel->mem;
	
	running = 1;

	STEREOSCOPE_DOLOOP();

	GDK_THREADS_ENTER();
	stereoscope_hide();
	GDK_THREADS_LEAVE();
}



static void stereoscope16(void *data)
{
	guint16 *loc;
	gint foo;
	char *oldsetl = oldEql;
	char *newsetl = actEql;
	char *oldsetr = oldEqr;
	char *newsetr = actEqr;
	guint16 *bitsr, *bitsl;
	int bar;  
	guint16 colEqr[65];
	guint16 colEql[65];
	int i, h;
	GdkWindow *win;
	GdkColormap *c;
	GdkVisual *v;
	GdkGC *gc;
	GdkColor raster_color;
	GdkColor bg_color;
		
	win = (GdkWindow *)data;
	GDK_THREADS_ENTER();
	c = gdk_window_get_colormap(win);
	gc = gdk_gc_new(win);
	v = gdk_window_get_visual(win);

	for (i = 0; i < 16; i++) {
		GdkColor color;
		color.red = (i*8) << 8;
		color.green = 255 << 8;
		color.blue = 0;
		gdk_color_alloc(c, &color);
		colEql[i] = color.pixel;
		colEqr[i] = color.pixel;
		color.red = 255 << 8;
		color.green = ((31 - i) * 8) << 8;
		color.blue = 0;
		gdk_color_alloc(c, &color);
		colEql[i + 16] = color.pixel;
		colEqr[i + 16] = color.pixel;
	}

	raster_color.red = 40 << 8;
	raster_color.green = 75 << 8;
	raster_color.blue = 0;
	gdk_color_alloc(c, &raster_color);

	// Create render image
	if (imagel) {
		gdk_image_destroy(imagel);	
		imagel = NULL;
	}
	imagel = gdk_image_new(GDK_IMAGE_FASTEST, v, 256, 64);
	if (imager) {
                gdk_image_destroy(imager);
                imager = NULL;
        }
        imager = gdk_image_new(GDK_IMAGE_FASTEST, v, 256, 64);
	
	bg_color.red = SCOPE_BG_RED << 8;
	bg_color.green = SCOPE_BG_GREEN << 8;
	bg_color.blue = SCOPE_BG_BLUE << 8;        
	gdk_color_alloc(c, &bg_color); 
	GDK_THREADS_LEAVE();
	
	assert(imager);
	assert(imagel);
	assert(imagel->bpp == 2);
	
	bitsr = (guint16 *)imager->mem;	
	bitsl = (guint16 *)imagel->mem;
	
	running = 1;

	STEREOSCOPE_DOLOOP();

	GDK_THREADS_ENTER();
	stereoscope_hide();
	GDK_THREADS_LEAVE();
}


static void stereoscope8(void *data)
{
	guint8 *loc;
	gint foo;
	char *oldsetl = oldEql;
	char *newsetl = actEql;
	char *oldsetr = oldEqr;
	char *newsetr = actEqr;
    guint8 *bitsr, *bitsl;
    int bar;  
	guint8 colEqr[65];
	guint8 colEql[65];
	int i, h;
	GdkWindow *win;
	GdkColormap *c;
	GdkVisual *v;
	GdkGC *gc;
	GdkColor raster_color;
	GdkColor bg_color;
	
	win = (GdkWindow *)data;
	GDK_THREADS_ENTER();
	c = gdk_window_get_colormap(win);
	gc = gdk_gc_new(win);
	v = gdk_window_get_visual(win);

	for (i = 0; i < 16; i++) {
		GdkColor color;
		color.red = (i*8) << 8;
		color.green = 255 << 8;
		color.blue = 0;
		gdk_color_alloc(c, &color);
		colEql[i] = color.pixel;
		colEqr[i] = color.pixel;
		color.red = 255 << 8;
		color.green = ((31 - i) * 8) << 8;
		color.blue = 0;
		gdk_color_alloc(c, &color);
		colEql[i + 16] = color.pixel;
		colEqr[i + 16] = color.pixel;
	}

	raster_color.red = 40 << 8;
	raster_color.green = 75 << 8;
	raster_color.blue = 0;
	gdk_color_alloc(c, &raster_color);

	// Create render image
	if (imagel) {
		gdk_image_destroy(imagel);	
		imagel = NULL;
	}
	imagel = gdk_image_new(GDK_IMAGE_FASTEST, v, 256, 64);
	if (imager) {
                gdk_image_destroy(imager);
                imager = NULL;
        }
        imager = gdk_image_new(GDK_IMAGE_FASTEST, v, 256, 64);
	
    bg_color.red = SCOPE_BG_RED << 8;
    bg_color.green = SCOPE_BG_GREEN << 8;
    bg_color.blue = SCOPE_BG_BLUE << 8;        
	gdk_color_alloc(c, &bg_color); 
	GDK_THREADS_LEAVE();
	
	assert(imager);
	assert(imagel);
	assert(imagel->bpp == 1);
	
	bitsr = (guint8 *)imager->mem;	
	bitsl = (guint8 *)imagel->mem;
	
	running = 1;

	STEREOSCOPE_DOLOOP();
	
	GDK_THREADS_ENTER();
	stereoscope_hide();
	GDK_THREADS_LEAVE();
}

static GdkVisual *visual;
static GdkWindow *win;

static void test_cb(GtkWidget *widget, gpointer data)
{
	printf("Woah!\n");
}


static void stop_stereoscope();

static gboolean close_stereoscope_window(GtkWidget *widget, GdkEvent *event, gpointer data)
{
        stop_stereoscope();

		return TRUE;
}


static GtkWidget *init_stereoscope_window()
{
	GtkWidget *stereoscope_win;
	GtkStyle *style;
	GdkColor *color;
		
	pthread_mutex_init(&stereoscope_mutex, NULL);
	
	style = gtk_style_new();
	stereoscope_win = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(stereoscope_win), "Stereoscope");
	gtk_widget_set_usize(stereoscope_win, 256,128);
	gtk_window_set_wmclass (GTK_WINDOW(stereoscope_win), "Stereoscope", "AlsaPlayer");
	gtk_window_set_policy (GTK_WINDOW (stereoscope_win), FALSE, FALSE, FALSE);
	style = gtk_style_copy(gtk_widget_get_style(GTK_WIDGET(stereoscope_win)));
	
	color = &style->bg[GTK_STATE_NORMAL];
	color->red = SCOPE_BG_RED << 8;
	color->blue = SCOPE_BG_BLUE << 8;
	color->green = SCOPE_BG_GREEN << 8;
	gdk_color_alloc(gtk_widget_get_colormap(GTK_WIDGET(stereoscope_win)), color);
	gtk_widget_set_style(GTK_WIDGET(stereoscope_win), style);
	
	gtk_widget_show(stereoscope_win);
	
	win = stereoscope_win->window;

	// Signals
		
	gtk_signal_connect(GTK_OBJECT(stereoscope_win), "delete_event",
                GTK_SIGNAL_FUNC(close_stereoscope_window), stereoscope_win);


	// Clear and show the window
	gdk_window_clear(win);
	gdk_window_show(win);
	gdk_flush(); 
	//gdk_threads_leave();

	ready_state = 1;

	return stereoscope_win;
}

static void stereoscope_hide()
{
	gint x, y;	
	if (scope_win) {
		gdk_window_get_root_origin(scope_win->window, &x, &y);
		gtk_widget_hide(scope_win);
		gtk_widget_set_uposition(scope_win, x, y);
	}
}

static void stop_stereoscope()
{
	running = 0;
}


static void run_stereoscope(void *data)
{
	running = 0;
	
	nice(SCOPE_NICE); // Be nice to most processes

	GDK_THREADS_ENTER();	
	visual = gdk_window_get_visual(win); 
	GDK_THREADS_LEAVE();

	switch (visual->depth) {
	 case 8:
		stereoscope8(win);
		break;
	 case 16:
		stereoscope16(win);
		break;
	 case 24:
	 case 32:
		stereoscope32(win);
		break;
		
	}
	//delete sub;
	pthread_mutex_unlock(&stereoscope_mutex); // Unlock
}


static void start_stereoscope(void *data)
{
	if (!is_init) {
		is_init = 1;
		scope_win = init_stereoscope_window();
	}
	if (pthread_mutex_trylock(&stereoscope_mutex) != 0) {
		printf("stereoscope already running\n");
		return;
	}
	gtk_widget_show(scope_win);
	pthread_create(&stereoscope_thread, NULL, (void * (*)(void *))run_stereoscope, data);
	pthread_detach(stereoscope_thread);
}

static int init_stereoscope()
{
	return 1;
}

static int open_stereoscope()
{
	return 1;
}

static void close_stereoscope()
{
}

static int stereoscope_running()
{
	return running;
}

scope_plugin stereoscope_plugin = {
		SCOPE_PLUGIN_VERSION,
        { "Stereoscope" },
        { "Andy Lo A Foe"},
        init_stereoscope,
        open_stereoscope,
        start_stereoscope,
		stereoscope_running,
        stop_stereoscope,
        close_stereoscope,
        stereoscope_set_data
};

scope_plugin *scope_plugin_info()
{
	return &stereoscope_plugin;
}

