/*
 * GUI front-end misc header
 *
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */
#ifndef __GDIFF_GUIMISC_H__
#define __GDIFF_GUIMISC_H__


#ifdef __cplusplus 
extern "C" {
#endif /* __cplusplus */

/*
 * Contant number
 */
/* The current view, used in make_label_for_notebook() at present.
   XXX: Might be very confused with PaneMode in properties.h. */
typedef enum {
	ONE_PANE_VIEW,
	TWO_PANE_VIEW,
	DIR_VIEW,
} CurrentView;
	
typedef enum {
	QD_YES = 0,
	QD_NO = 1,
	QD_CANCEL = 2,
} QDialogReply;

	
/* Forward declarations of types. */
typedef struct _FontProp FontProp;
typedef struct _BufInfo BufInfo;
typedef struct _LineFormat LineFormat;

	
/*
 * Data structure definitions
 */
/* Font property */
struct _FontProp {
	GdkFont *font;
	GdkColor *fg;
	GdkColor *bg;
};

/* Buffer information. max_lenb is used to avoid overrun. */
struct _BufInfo {
	const char *buf;
	int lenb;/* Length of buffer(Bytes) */
};

/* Format of line numbers */
struct _LineFormat {
	int n_col; /* The number of columns of inserted numbers. (e.g. n_col=3 implies from "1" to "999".) */
	const char *format; /* format for each inserted numbers. (e.g. "%4d> ") */
};

	
/* Global function declarations */
/* guimisc.c */
extern int draw_text_lines(GtkText *text, const FontProp *fprop, const BufInfo *binfo, int nl);
extern int insert_remove_line_numbers(GtkText *text, gboolean b_in, int *pos, const FontProp *fprop, const BufInfo *binfo, int begin, int nline, const LineFormat *lformat);
extern GtkWidget* make_label_for_notebook(const char *f1, const char *f2, CurrentView cv);
extern char* make_current_info_msg(const char *fname1, const char *fname2, int f1n1, int f1n2, int f2n1, int f2n2); 
extern QDialogReply ask_yes_no(const char *msg);
extern gboolean is_files_different(DiffFiles *files, gboolean b_show_msg);
extern int guess_visible_top_line(GtkAdjustment *adj, int total);
extern int guess_visible_center_line(GtkAdjustment *adj, int total);
extern int guess_visible_bottom_line(GtkAdjustment *adj, int total);
	

#ifdef __cplusplus
} 
#endif /* __cplusplus */
 
#endif /* __GDIFF_GUIMISC_H__ */
