/*
 * Header for the routines to decide whether file will be hidden on directory view.
 *
 * Every function follows as,
 * typedef gboolean (*RowHideFunc)(const char *fname);
 * The file specified by fname should be hidden, the function returns TRUE.
 *
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */

#ifndef __GDIFF_HIDE_H__
#define __GDIFF_HIDE_H__

#ifdef __cplusplus 
extern "C" {
#endif /* __cplusplus */


/* To decide whether the row is hidden on directory view. */
typedef gboolean (*RowHideFunc)(const char *fname);

/* Global function declarations */
/* When added a new function, update rh_func_array[] in menu.c */
extern gboolean hide_emacs_backup(const char *fname);
extern gboolean hide_obj_file(const char *fname);

#ifdef __cplusplus
} 
#endif /* __cplusplus */
 
#endif /* __GDIFF_HIDE_H__ */
