/*
 * Copyright (c) 1997, 1999  Motoyuki Kasahara
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef NDTPD_H
#define NDTPD_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <time.h>
#include <sys/types.h>

#include <eb/eb.h>
#include <eb/error.h>
#include <eb/text.h>

#include "defs.h"
#include "linebuf.h"
#include "readconf.h"
#include "permission.h"
#include "ticket.h"

/*
 * Book -- represents a book.
 */
typedef struct book {
    /*
     * Path of the book.
     */
    char *path;

    /*
     * Path of the book.
     */
    char *appendix_path;

    /*
     * Name of the book.
     */
    char name[MAXLEN_BOOK_NAME + 1];

    /*
     * Current subbook name (= directory name).
     */
    const char *subname;

    /*
     * Current font height.
     */
    int height;

    /*
     * Access permission to the current client.
     */
    int permflag;

    /*
     * Title of the book.
     */
    char title[MAXLEN_BOOK_TITLE + 1];

    /*
     * The maximum number of connections to the book.
     */
    int max_clients;

    /*
     * Access permission list to the book.
     */
    Permission permissions;

    /*
     * Ticket stock (`max-clients' controler).
     */
    Ticket_Stock ticket_stock;

    /*
     * Entity of the CD-ROM book.
     */
    EB_Book book;

    /*
     * Appendix entitiy of the CD-ROM book.
     */
    EB_Appendix appendix;

    /*
     * Refer to a next book.
     * Set to NULL when there is no more book.
     */
    struct book *next;
} Book;

/*
 * Trick for function protypes.
 */
#ifndef NDTPD_P
#ifdef __STDC__
#define NDTPD_P(p)	p
#else /* not __STDC__ */
#define NDTPD_P(p)	()
#endif /* not __STDC__ */
#endif /* EB_P */

/*
 * Function declarations.
 */
/* book.c */
void initialize_book_registry NDTPD_P((void));
void clear_book_registry NDTPD_P((void));
void terminate_book_registry NDTPD_P((void));
int count_book_registry NDTPD_P((void));
int activate_book_registry NDTPD_P((void));
int add_book NDTPD_P((void));
Book *find_book NDTPD_P((const char *));
EB_Subbook_Code find_subbook NDTPD_P((const char *));
EB_Subbook_Code find_appendix_subbook NDTPD_P((const char *));
void check_book_permissions NDTPD_P((void));
void set_all_book_permissions NDTPD_P((void));
/* ndtp.c */
int ndtp_main NDTPD_P((void));
/* texthook.c */
void initialize_hookset NDTPD_P((void));

/*
 * Global variables.
 */
extern Configuration configuration_table[];
extern const char *invoked_name;
extern const char *program_name;
extern const char *program_version;
extern char work_path[];
extern char configuration_filename[];
extern char server_name[];
extern int listening_port;
extern int old_listening_port;
extern int listening_file;
extern int accepted_file;
extern uid_t user_id;
extern gid_t group_id;
extern char pid_filename[];
extern char old_pid_filename[];
extern char connection_lock_filename[];
extern Ticket_Stock connection_ticket_stock;
extern int max_clients;
extern int connection_count;
extern int idle_timeout;
extern Permission identifications;
extern int identification_timeout;
extern Permission permissions;
extern Book *book_registry;
extern Book *book_registry_tail;
extern int book_count;
extern Book *current_book;
extern int max_hits;
extern size_t max_text_size;
extern EB_Hookset text_hookset;
extern char client_hostname[];
extern char client_address[];
extern char client_user[];
extern int server_mode;
extern int syslog_facility;
extern Line_Buffer line_buffer;
extern char alias_eiwa[];
extern char alias_waei[];
extern char alias_kojien[];

#endif /* not NDTPD_H */
