/******************************************************************************\
 gnofin/account.h   $Revision: 1.11 $
 Copyright (C) 1999 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#ifndef FIN_ACCOUNT_H
#define FIN_ACCOUNT_H

#include <glib.h>
#include <stdio.h>

typedef struct _FinAccount	FinAccount;
typedef struct _FinAccountSet	FinAccountSet;

#include "record.h"
#include "money.h"

#define FIN_ACCOUNT_NAME_MAX	50

struct _FinAccount
{
  gint    ref_count;
  gchar * name;		/* account name, such as "checking" */
  gchar * info;		/* account info, such as "01423-01126" */
  GList * records;	/* list of all associated transaction records */
  money_t cleared_bal;	/* sum of all cleared transaction amounts */
};

struct _FinAccountSet
{
  gint    ref_count;
  gchar * header_line;  /* optional comment line in accounts file, NULL if none */
  GList * info_cache;
  GList * accounts;
};

FinAccount * 	fin_account_new                 (const gchar * name,
				                 const gchar * info);
void	 	fin_account_ref                 (FinAccount * account);
void	 	fin_account_unref               (FinAccount * account);
FinAccount *	fin_account_dup	                (FinAccount * account);
void		fin_account_dump                (FinAccount * account,
				                 FILE       * stream);
gint		fin_account_sort_fcn            (FinAccount * a, 
				                 FinAccount * b);
void            fin_account_refresh_cleared_bal (FinAccount * account);
void		fin_account_store_record        (FinAccount * account,
					         FinRecord  * record,
					         gint	      sort);

FinAccountSet *	fin_account_set_new  ();
void 		fin_account_set_ref  (FinAccountSet * set);
void 		fin_account_set_unref(FinAccountSet * set);
FinAccountSet *	fin_account_set_load (const gchar   * filename,
				      gchar         * reason_for_failure,
				      gint	      bufsize);
gboolean	fin_account_set_save (FinAccountSet * set,
				      const gchar   * filename,
				      gchar	    * reason_for_failure,
				      gint	      bufsize);
//FinAccountSet *	fin_account_set_copy (FinAccountSet * set,
//				      gint	      prune);  /* remove unref'd info strings */
void		fin_account_set_dump (FinAccountSet * set,
				      FILE          * stream);

/* if sort == false, these functions append item */
void		fin_account_set_store_account	  (FinAccountSet * set,
						   FinAccount    * account,
						   gint	    	   sort);
void		fin_account_set_store_info_string (FinAccountSet * set,
						   const gchar   * string,
						   gint	    	   sort);

FinAccount *    fin_account_set_lookup_account (FinAccountSet * set,
					        const gchar   * name);

/* creates other record and links both to each other
 * newly created record is "prepended" to dest_account->records
 */
FinRecord *	fin_account_set_transfer_funds (FinAccountSet * set,
						FinAccount    * source_account,
						FinRecord     * source_record,
						FinAccount    * dest_account);

#endif
