/*
 * Hardware tuning for the Intel 82437VX TDX Host bridge
 */

/*
 * Notes:
   The VX seems to have a few 'issues' which we should take care of at some point.
   1. If L2 cache is present, we should not enable speculative leadoff. Timing issues
      may exist on cache misses.
   2. PCI bursting should not be enabled if a video card using the ET4000/w32 chipset
      is detected.
 */

#include "82437.h"
#define Intel_82437VX_TWEAKSIZE sizeof(Intel_82437VX_Tweaks)/sizeof(Tweaks_t)-1

unsigned int getnumtweaks_Intel_82437VX(struct pci_dev *current_dev)
{
	return Intel_82437VX_TWEAKSIZE;
}

void init_Intel_82437VX(struct pci_dev *current_dev)
{
	init_tweaks (Intel_82437VX_TWEAKSIZE, Intel_82437VX_Tweaks, current_dev);
}

void tune_Intel_82437VX(GtkWidget *table, struct pci_dev *current_dev, unsigned int numbuttons)
{
	Tweaks_t *Tweaks;

	unsigned int index;
	int column=0;

	Tweaks = Intel_82437VX_Tweaks;

	for (index=0;index<numbuttons;index++) {
		CreateButton(table, Tweaks, current_dev, column);
		column++;
		Tweaks++;
	}
}

void save_Intel_82437VX(FILE *savehandle, struct pci_dev *current_dev)
{
	write_tweaks(savehandle, Intel_82437VX_TWEAKSIZE, Intel_82437VX_Tweaks, current_dev);
}
