/*
 * Copyright (c) 2000 Dave Jones <dave@powertweak.com>
 *
 * Can be freely distributed and used under the terms of the GNU GPL.
 */

#include "CPU/CPUID_features.c"
#include "CPU/info_generic.c"
#include "CPU/info_AMD.c"
#include "CPU/info_CYRIX.c"
#include "CPU/info_IDT.c"
#include "CPU/info_INTEL.c"


void select_CPU_item(void)
{
	remove_all_pages(notebook);

	identify_CPU();

	switch (cpu0_data.vendor) {
		case CPU_VENDOR_AMD:
			show_CPU_info_AMD();
			break;

		case CPU_VENDOR_CYRIX:
			show_CPU_info_CYRIX();
			break;

		case CPU_VENDOR_IDT:
			show_CPU_info_IDT();
			break;

		case CPU_VENDOR_INTEL:
			show_CPU_info_Intel();
			break;

		default:
			show_CPU_info_generic();
			break;
	}
}
