#!/usr/bin/perl

#
# MakeMake.pl -- tool for auto creating of makefiles
# 
# (c) Vladi Belperchinov-Shabanski  (c) Ivaylo Baylov 1998
#
#
# DISTRIBUTED `AS IS' WITHOUT ANY KIND OF WARRANTY OR ELSE.
# YOU MAY USE, MODIFY AND DISTRIBUTE THIS UTILITY AS LONG AS 
# THE ORIGINAL CREDITS ARE KEPT INTACT! 
# ( AND YOU CREDIT YOURSELF FOR THE APROPRIATE MODIFICATIONS ONLY )
#
# CREDITS ANS MODIFICATIONS:
#
# dec98: first version -- though there were a number of utilities like
#                         this I still haven't found what I'm looking for...
#                         the closest approach is `tmake' of Troll Tech
#                         used for `Qt', but is far too complex...
#

#
# GENERAL USAGE AND TIPS:
# input file is `mm.conf' or/and `make.make'
# output is to the stdout
#
# ---sample-mm.conf-is:---
# $CC      = "gcc";
# $LD      = "gcc";
# $CCFLAGS = "-I../vslib -I/usr/include/ncurses -O2";
# $LDFLAGS = "-L../vslib -lvslib -lncurses";
# $TARGET  = "vfu";
# $SRC     = "*.cpp";
# $HDR     = "*.h";
# ---sample-ends-here---
#
# ...more still to come...
#

if ( !(( -e "mm.conf" ) || ( -e "make.make" )) ) 
  { die "makemake.pl: cannot find neither mm.conf nor make.make files\n" };

do 'mm.conf';
do 'make.make';

print "### MAKEMAKE STARTS HERE #########################################\n\n";


if ( $CC     eq "" ) { $CC = "gcc" };
if ( $LD     eq "" ) { $LD = "gcc" };
if ( $AR     eq "" ) { $AR = "ar rvs" };
if ( $TARGET eq "" ) { $TARGET = "a.out" };

print "CC      = $CC\n";
print "LD      = $LD\n";
print "AR      = $AR\n";
print "CFLAGS  = $CFLAGS $CCFLAGS\n";
print "CCFLAGS = $CFLAGS $CCFLAGS\n";
print "LDFLAGS = $LDFLAGS\n";
print "ARFLAGS = $ARFLAGS\n";
print "TARGET  = $TARGET\n";
print "\n";
print "# IN.SRC = $SRC\n";
print "# IN.HDR = $HDR\n";


if ( $SRC eq "" ) { $SRC = "*.cpp *.c *.cc *.cxx" };
if ( $HDR eq "" ) { $HDR = "*.h *.hpp" };

@FLS = _glob($SRC);
@HS  = _glob($HDR);

while($_ = pop( @FLS ))  
  {
  push SRC,$_;
  /(.*)\.[^\.]+/;
  push OBJ,"$1.o";
  }

print "\n### SOURCES ######################################################\n\n";

print "SRC= \\\n";
$c = 0;
while( $c < $#SRC )
  {
  print "     $SRC[$c] \\\n";
  $c++;
  }
  print "     $SRC[$c]\n";

print "\n#### OBJECTS #####################################################\n\n";
print "OBJ= \\\n";
$c = 0;
while( $c < $#OBJ )
  {
  print "     $OBJ[$c] \\\n";
  $c++;
  }
  print "     $OBJ[$c]\n";

print "\n### TARGETS ######################################################\n\n";

print "default: all\n\n";

print "all: \$(TARGET)\n";
if ($TARGET =~ /\.a[ \t]*$/)
  { 
  print "\$(TARGET): \$(OBJ)\n\t\$(AR) \$(ARFLAGS) \$(TARGET) \$(OBJ)\n";
  }
else
  {  
  print "\$(TARGET): \$(OBJ)\n\t\$(LD) \$(OBJ) \$(LDFLAGS) -o \$(TARGET)\n";
  }

print "clean: \n\trm -f \$(TARGET) \$(OBJ)\n\n";

print "\n### DEPENDENCES ##################################################\n\n";

@FLS = @SRC;
push @FLS, @HS;
$c = 0;
while( $c <= $#FLS )
  {
  
  print "$FLS[$c]:";
  open( i , $FLS[$c] );
  while(<i>)
    {
    if (/^[ \t]*\#include[ \t]*[\"]([^\"]+)[\"]/) { print " $1"; }
    }
  close( i );
  print "\n\t\n"; 
  $c++;
  }

print "\n### TARGET OBJECTS ###############################################\n\n";

$c = 0;
while( $c <= $#OBJ )
  {
  print "$OBJ[$c]: $SRC[$c]\n\t\$(CC) \$(CFLAGS) -c $SRC[$c] -o $OBJ[$c]\n";
  $c++;
  }

print "\n### END ##########################################################\n";


#-----------------------------------------------------------------------------

sub _glob
{
  @_ = split( / /, `ls @_[0] | tr "\n" " " ` );
}

#---end-----------------------------------------------------------------------
