/*
 *
 * (c) Vladi Belperchinov-Shabanski "Cade" <cade@biscom.net> 1996-1999
 *
 * SEE `README',`LICENSE' OR `COPYING' FILE FOR LICENSE AND OTHER DETAILS!
 *
 */


#include "vfuarc.h"
#include "vfuuti.h"
#include "vfuopt.h"
#include "vfudir.h"
#include "vfucopy.h"
#include "vfufiles.h"

  // NOTE: for extract commands need `%s%s' to construct CPath/AName 'cos
  // the current path will be changed to the target
  ArcItem      Arcs[] = {
  #ifdef _TARGET_UNIX_
  { ".zip", "unzip -v   %s" , "unzip      %s%s `cat %s`", "unzip      %s%s    %s" , "unzip -c   %s %s > %s", "^ *([0123456789]+).*-.*:.* ([^ ]*[^/]) *$", 2, 1 },
  #else
  { ".zip", "unzip -v   %s" , "unzip      %s%s    @%s"  , "unzip      %s%s    %s"   , "unzip -c   %s %s > %s", "^ *([0123456789]+).*-.*:.* ([^ ]*[^/]) *$", 2, 1 },
  #endif
  { ".arj", "arj v      %s" , "arj x   -y %s%s    !%s"  , "arj x   -y %s%s    %s"   , "arj p      %s %s > %s", "^\\+([^ ]+) +([0123456789]+) *$", 1, 2 },
  { ".tar", "tar tvf    %s" , "tar xvf    %s%s -T  %s"  , "tar xvf    %s%s    %s"   , "tar xOvf   %s %s > %s", ".* ([0123456789]+) .* ([^ ]+[^/]) *$", 2, 1 },
  { ".tgz", "tar tzvf   %s" , "tar xzvf   %s%s -T  %s"  , "tar xzvf   %s%s    %s"   , "tar xOzvf  %s %s > %s", ".* ([0123456789]+) .* ([^ ]+[^/]) *$", 2, 1 },
  { ".tar.gz" , "tar tzvf   %s" , "tar xzvf   %s%s -T  %s"  , "tar xzvf   %s%s    %s"   , "tar xOzvf  %s %s > %s", ".* ([0123456789]+) .* ([^ ]+[^/]) *$", 2, 1 },
  { ".tbz", "tar tIvf   %s" , "tar xIvf   %s%s -T  %s"  , "tar xIvf   %s%s    %s"   , "tar xOIvf  %s %s > %s", ".* ([0123456789]+) .* ([^ ]+[^/]) *$", 2, 1 },
  { ".tar.bz2", "tar tIvf   %s" , "tar xIvf   %s%s -T  %s"  , "tar xIvf   %s%s    %s"   , "tar xOIvf  %s %s > %s", ".* ([0123456789]+) .* ([^ ]+[^/]) *$", 2, 1 },
  { ".uc2", "uc \\d     %s" , "uc  es  -F %s%s    @%s"  , "uc  es  -F %s%s    %s"   , "uc $PRF    %s %s > %s", "^\\+([^ ]+) +([0123456789]+) *$", 1, 2 },
  { ".lzh", "lha v      %s" , "-"                       , "lha e      %s%s    %s"   , "lha p -p   %s %s > %s", "^\\+([^ ]+) +([0123456789]+) *$", 1, 2 },
  { ".rar", "rar v -std %s" , "rar x -std %s%s    @%s"  , "rar x -std %s%s    %s"   , "rar p -std %s %s > %s", "^\\+([^ ]+) +([0123456789]+) *$", 1, 2 },
  { ".ha" , "ha  lf     %s" , "-"                       , "ha  xy     %s%s    %s"   , "-", "^\\+([^ ]+) +([0123456789]+) *$", 1, 2 },
  { ".j"  , "jar v      %s" , "jar x   -y %s%s    @%s"  , "jar x   -y %s%s    %s"   , "-", "^\\+([^ ]+) +([0123456789]+) *$", 1, 2 },
  { ".lim", "limit l    %s" , "limit e -p %s%s    @%s"  , "limit e -p %s%s    %s"   , "-", "^\\+([^ ]+) +([0123456789]+) *$", 1, 2 },
  { ".ftp", "ftparc -l  %s" , "ftparc -x -q  %s%s    @%s"  , "ftparc -x -q %s%s %s"   , "ftparc -p -q %s %s > %s", ".* ([0123456789]+) [A-Z].* ([^ ]+[^/]) *$", 2, 1 },
  { ".deb", "debarc  l  %s" , "debarc  x     %s%s  -T %s"  , "debarc  x    %s%s %s"   , "debarc  p    %s %s > %s", ".* ([0123456789]+) .* ([^ ]+[^/]) *$", 2, 1 },
  { "---", "", "", "", "", "", 0, 0 }
//  { "arj", "arj l    %s" , "arj e      %s%s    !%s" , "arj p     %s %s > %s", "^ *([^ ]+) +([0123456789]+) +", 1, 2 },
//  { "j"  , "jar -l %a", "jar e %s !%s", "jar ", "", 0, 0 },
  };

  int FindArc( const char *fname )
  {
    char tmp[256];
    strcpy( tmp, fname );
    if (opt.NoCaseArcs) StrLowCase( tmp );
    const char *pc = fname + strlen( fname );
    int z = 0;
    while(1)
      {
      if (Arcs[z].ext[0] == '-') break;
      int e = strlen( Arcs[z].ext );
      if (PathCmp( Arcs[z].ext, pc - e ) == 0) return z;
      z++;
      }
    return -1;
  }

/////////////////////////////////////////////
//
// Archivers listing hacks(fix)
//

  void FixUC2( PSZCluster &sc )
  {
    unlink( "u$~reslt.ok" ); // :( however I should try that

    int z;
    String dirprefix;
    String name;
    String size;
    String vers;
    char *pc;

    z = -1;
    while(1)
      {
      z++;
      if ( z == sc.count() ) break;
      pc = sc[z];
      if( pc[0] == '+' ) break;

      if (strncmp( pc, "LIST [", 6 ) == 0)
        {
        dirprefix = pc;
        StrTrimL( dirprefix, 6 );
        StrTrimR( dirprefix, 1 );
        StrTrimL( dirprefix, 1 ); // for the leading '/'
        continue;
        }
      if (strncmp( pc, "   FILE", 7 ) == 0)
        {
        int i = 1;
        while(i-6)
          {
          pc = sc[z+i];
          if (strncmp( pc, "      NAME=", 11 ) == 0)
            {
            name = pc;
            StrTrimL( name, 12 );
            StrTrimR( name,  1 );
            } else
          if (strncmp( pc, "      SIZE=", 11 ) == 0)
            {
            size = pc;
            StrTrimL( size, 11 );
            }
          if (strncmp( pc, "      VERSION=", 11 ) == 0)
            {
            vers = pc;
            StrTrimL( vers, 14 );
            if ( atoi(vers) == 0 )
              vers = "";
            else
              vers = ";" + vers;
            }
          i++;
          }
        name = "+" + dirprefix + name + vers + " " + size;
        sc.add( name );
        }
      }
    while ( sc.count() && sc[0][0] != '+' ) sc.free(0);
  };

  void FixARJ( PSZCluster &sc )
  {
    String name; String size; String vers; char *pc;
    int z = -1;
    while(1)
      {
      z++; if ( z == sc.count() ) break;
      pc = sc[z]; if( pc[0] == '+' ) break;

      if ( pc[3] == ')' && pc[4] == ' ' )
        {
        name = pc; StrTrimL( name, 5 );
        size = sc[z+1]; StrTrimL( size, 12 ); StrSLeft( size, 12); StrCutSpc( size );
        name = "+" + name + " " + size;
        sc.add( name );
        }
      }
    while ( sc.count() && sc[0][0] != '+' ) sc.free(0);
  }

  void FixLZH( PSZCluster &sc )
  {
    String name; String size; String vers; char *pc;
    int z = -1;
    while(1)
      {
      z++; if ( z == sc.count() ) break;
      pc = sc[z]; if( pc[0] == '+' ) break;

      name = pc;
      if ( name.len() > 0 && StrCount( name, " " ) == 0 )
        {
        size = sc[z+1];
        StrTrimL( size, 14);
        StrSLeft( size, 11);
        StrCutSpc( size );
        name = "+" + name + " " + size;
        sc.add( name );
        }
      }
    while ( sc.count() && sc[0][0] != '+' ) sc.free(0);
  }

  void FixRAR( PSZCluster &sc )
  {
    String name; String size; String vers; char *pc;
    int z = -1;
    while ( sc.count() && strncmp( sc[0], "-----", 5 ) ) sc.free(0);
    sc.free(0);
    while(1)
      {
      z++; if ( z == sc.count() ) break;
      pc = sc[z]; if ( pc[0] == '+' || strncmp( pc, "-----", 5 ) == 0 ) break;

      name = pc; StrCutSpc( name );
      if ( name.len() > 0 && StrCount( name, " " ) == 0 )
        {
        size = sc[z+1];
//        size.TrimL(14);
        StrSLeft( size, 23);
        StrCutSpc( size );
        name = "+" + name + " " + size;
        if (atoi(size.asis()) != 0) sc.add( name );
        }
      }
    while ( sc.count() && sc[0][0] != '+' ) sc.free(0);
  }

  void FixJAR( PSZCluster &sc )
  {
    String name; String size; String vers; char *pc;
    int z = -1;
    while(1)
      {
      z++; if ( z == sc.count() ) break;
      pc = sc[z]; if( pc[0] == '+' ) break;

      if ( strstr( pc, ") " ) && !strstr( pc, "(" ) )
        {
        name = pc; StrGetFirstWord( name, " ", sss );
        size = sc[z+1]; StrSLeft( size, 11); StrCutSpc( size );
        name = "+" + name + " " + size;
        if (atoi(size.asis()) != 0) sc.add( name );
        }
      }
    while ( sc.count() && sc[0][0] != '+' ) sc.free(0);
  }

  void FixLIMIT( PSZCluster &sc )
  {
    String dirprefix; String name; String size; String vers; char *pc;
    int z = -1;
    while(1)
      {
      z++; if ( z == sc.count() ) break;
      pc = sc[z]; if( pc[0] == '+' ) break;
      pc = sc[z];
      if (strstr( pc, "file(s)" )) continue;

      if (pc[0] == '[' && pc[1] == '\\')
        {
        dirprefix = pc+2; StrTrimR( dirprefix, 1 ); StrAddCh( dirprefix, '\\' );
        continue;
        }

      name = pc; StrSetCh( name, 10, '.' ); StrSLeft( name, 14); StrReplace( name, " ", "" );
      size = pc+14; StrSLeft( size, 10 ); StrReplace( size, " ", "" );

      name = "+" + dirprefix + name + " " + size;
      sc.add(name);
      }
    while ( sc.count() && sc[0][0] != '+' ) sc.free(0);
  }

  void FixHA( PSZCluster &sc )
  {
    String name; String size; String vers; char *pc;
    regexp *re_line = regcomp("^ *([^ ]+) +([0123456789]+) +.*\\:.*$");

    int z = -1;
    while(1)
      {
      z++; if ( z == sc.count() ) break;
      pc = sc[z]; if( pc[0] == '+' ) break;

      if ( regexec( re_line, pc ) )
        {
        regsubn( re_line, 1, sss ); name = sss;
        regsubn( re_line, 2, sss ); size = sss;
        strcpy(sss,sc[z+1]);
        StrTrimL( sss, 11 );
        if (sss[0] == '.') sss[0] = 0;
        name = sss + name;
        name = "+" + name + " " + size;
        sc.add( name );
        }
      }
    while ( sc.count() && sc[0][0] != '+' ) sc.free(0);
    free( re_line );
  }

/////////////////////////////////////////////
//
// ReadArchiveFiles...
//
  void ReadArchiveFiles()
  {
    ASSERT( AX != -1 );
    int z;
    String str;
    ////////////////////////////////////////////////////////////////////////
    PSZCluster sc;
    sc.create( 16, 16 );

    sprintf( sss, Arcs[AX].list_cmd, AName );
    say1( sss );

    ConXY( 1, MAXY );
    FILE *f = popen( sss, "r" );
    LoadFromFile( f, &sc, 1024 );
    pclose( f );
    ConCHide(); // this is a hack for UC2 (it show cursor?)
    draw = 1;

    //-hacks------------
    if(strcasecmp(Arcs[AX].ext, "uc2") == 0) FixUC2( sc );
    if(strcasecmp(Arcs[AX].ext, "arj") == 0) FixARJ( sc );
    if(strcasecmp(Arcs[AX].ext, "lzh") == 0) FixLZH( sc );
    if(strcasecmp(Arcs[AX].ext, "rar") == 0) FixRAR( sc );
    if(strcasecmp(Arcs[AX].ext, "j"  ) == 0) FixJAR( sc );
    if(strcasecmp(Arcs[AX].ext, "lim") == 0) FixLIMIT( sc );
    if(strcasecmp(Arcs[AX].ext, "ha" ) == 0) FixHA( sc );
    //------------------

    regexp *re = regcomp( Arcs[AX].re_files );
    for( z = 0; z < sc.count(); z++ )
      {
      if (regexec( re, sc[z] ))
        {
        TF* fitem = new TF;
        memset( fitem, 0, sizeof(TF) );

        strcpy(fitem->sttype, "@@");

        if (Arcs[AX].rn_size)
          {
          regsubn( re, Arcs[AX].rn_size, sss );
          fitem->size = atof( sss );
          fitem->st.st_size = long(fitem->size);
          }

        regsubn( re, Arcs[AX].rn_fname, sss );
        StrTR( sss, "\\", "/" );
        strcpy( fitem->name, sss );
        fitem->fname = strrchr( fitem->name, '/' );
        if ( fitem->fname ) fitem->fname++; else fitem->fname = fitem->name;
        strcpy( fitem->stmode, ATTR_OFF );

        Files[FilesCount] = fitem;
        FilesCount++;
        if ( FilesCount >= MaxFiles ) break;
        }
      }
    free( re );

    sc.done();
    ////////////////////////////////////////////////////////////////////////

  }

////////////////////////////////////////////////////////////////////////////
//
//
//

  void ViewArchiveFile()
  {
    char tmp[MAX_PATH];
    char tmp2[MAX_PATH];
    tmpnam( tmp );
    strcpy( tmp2, tmp );
    FixPath( tmp2 );

    const char *finame = Files[FLI]->name;

    if(mkdir( tmp, S_IRUSR|S_IWUSR|S_IXUSR|S_IRGRP|S_IXGRP|S_IROTH|S_IXOTH ))
      {
      sprintf(sss, "Cannot create temp path: %s", tmp);
      say1(sss);
      return;
      }

    chdir( tmp );

    if (strcasecmp(Arcs[AX].ext,"uc2") == 0 )
      { // uc2 hack
      char _fnonly[MAX_PATH];
      FileNameExt( finame, _fnonly );
      sprintf( sss, Arcs[AX].extrs_cmd, CPath, AName, _fnonly );
      }
    else
      sprintf( sss, Arcs[AX].extrs_cmd, CPath, AName, finame );
    #ifdef _TARGET_GO32_
    StrTR( sss, "/", "\\" ); // BIG HACK -- sorry I'll fix it later
    #endif
    ConCS();
    say1( sss );
    Shell( sss, 0, 0 );
    Browse( finame );

    EraseDir( tmp );
  }

  void ArcUserExternal( const char *cmdline )
  {
    char tmp[MAX_PATH];
    char tmp2[MAX_PATH];
    tmpnam( tmp );
    strcpy( tmp2, tmp );
    FixPath( tmp2 );

    const char *finame = Files[FLI]->name;

    if(mkdir( tmp, S_IRUSR|S_IWUSR|S_IXUSR|S_IRGRP|S_IXGRP|S_IROTH|S_IXOTH ))
      {
      sprintf(sss, "Cannot create temp path: %s", tmp);
      say1(sss);
      return;
      }

    chdir( tmp );

    // extracting file
    sprintf( sss, Arcs[AX].extrs_cmd, CPath, AName, finame );
    #ifdef _TARGET_GO32_
    StrTR( sss, "/", "\\" ); // BIG HACK -- sorry I'll fix it later
    #endif
    ConCS();
    say1( sss );
    Shell( sss, 0, 0 );
    // file extracted -- continue

    strcat( tmp2, finame );
    #ifdef _TARGET_GO32_
    if ( StrFind( cmdline, "%_" ) != -1 )
      {
      get_sfn( tmp2, sss );
      strcpy( tmp2, sss );
      }
    if ( StrFind( cmdline, "%\\" ))
      StrTR( tmp2, "/", "\\" ); // BIG HACK -- sorry I'll fix it later
    #endif
    strcpy( sss, cmdline );
    StrReplace( sss, "%f", "%F" );
    StrReplace( sss, "%F", tmp2 );

    ConCS();
    say1( sss );
    Shell( sss, 0, 0 );

    EraseDir( tmp );
  }

/*
  void ViewArchiveFile2()
  {
    ASSERT( AX != -1 );

    if (Arcs[AX].view_cmd[0] == '-')
      {
      say1( "<BROWSE/VIEW> is not supported for this archive type!" );
      return;
      }

    ConCS();
    sprintf( sss, Arcs[AX].view_cmd, AName, Files[FLI]->name, ArcTempFile );
    Shell( sss, 0 );
    // String str = Browser; StrReplace( str,"%F", "%f" ); StrReplace( str,"%f", ArcTempFile );
    // Shell( str, 0 );
    Browse( ArcTempFile );
    unlink( ArcTempFile );
  }
*/

////////////////////////////////////////////////////////////////////////////
//
//
//

  void ExtractArchiveFiles( int one )
  {
    ASSERT( AX != -1 );
    if (Arcs[AX].extrl_cmd[0] == '-')
      {
      say1( "<EXTRACT> is not supported for this archive type!" );
      return;
      }

    if ( SelCount == 0 && one == 0 ) one = 1;
    char temp[255];

    if ( one == 0) sprintf(temp, "EXTRACT SELECTION to: " );
    else
    if ( one == 1 )
      sprintf(temp, "EXTRACT `%s' to:", Files[FLI]->name);
    else
      return;
    GetDirName(temp, opt.LastCopyPath[cmCOPY] );
    if (TargetDir[0] == 0) return;

    strcpy(opt.LastCopyPath[cmCOPY], TargetDir);
    say1("");

    PSZCluster sc; sc.create( 16, 16 );

    int z;
    for(z = 0; z < FilesCount; z++ )
      if ((Files[z]->sel && one == 0) || (z == FLI && one == 1))
        {
        TF *fi = Files[z];
        ASSERT( !fi->is_dir );
        sc.add( fi->name );
        }
    if (chdir(TargetDir))
      {
      sprintf( sss, "Cannot chdir to: %s", TargetDir ); say1( sss );
      DescribeErrno();
      return;
      }
    if (SaveToFile( ArcTempFile, &sc ))
      {
      sprintf( sss, "Error writing list file: %s", ArcTempFile ); say1( sss );
      return;
      }
    sprintf( sss, Arcs[AX].extrl_cmd, CPath, AName, ArcTempFile );
    #ifdef _TARGET_GO32_
    StrTR( sss, "/", "\\" ); // BIG HACK -- sorry I'll fix it later
    #endif
    ConCS();
    say1( sss );
    Shell( sss, 0, 0 );
    if (unlink( ArcTempFile ))
      {
      sprintf( sss, "Cannot unlink/erase temp file: %s", ArcTempFile ); say2( sss );
      }
    if (chdir(CPath))
      {
      sprintf( sss, "Cannot chdir back to to: %s", CPath ); say1( sss );
      DescribeErrno();
      return;
      }
    say1( "EXTRACT ok." );
  }

////////////////////////////////////////////////////////////////////////////
//
//
//


 // eof vfuarc.cpp
