/* Bluefish HTML Editor
 *
 * Copyright (C) 1999 Olivier Sessink
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <gtk/gtk.h>

#include <locale.h>
#include <libintl.h>
#define _(STRING) gettext(STRING)

#include "debug.h"

/*
 * Function: combo_with_popdown
 * Arguments:
 * 	setstring - string to setb in textbox, if NULL set ""
 * 	which_list - GList to set in popdown widget
 * 	editable - if editable (1 or 0)
 * Return value:
 * 	Pointer to create combo
 * Description:
 * 	Create new combo and preset some values
 */
GtkWidget *combo_with_popdown( gchar *setstring , GList *which_list, gint editable) {

  GtkWidget *returnwidget;
  
  returnwidget = gtk_combo_new();
  if (which_list != NULL) {
    gtk_combo_set_popdown_strings(GTK_COMBO(returnwidget), which_list);
  }
  if (setstring != NULL) {
    gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(returnwidget)->entry), setstring);
  } else {
	  gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(returnwidget)->entry), "");
  }
  if (editable == 0) {
    gtk_editable_set_editable(GTK_EDITABLE(GTK_ENTRY(GTK_COMBO(returnwidget)->entry)), FALSE);
  }
  return returnwidget;
}


/*
 * Function: bf_stock_button
 * Arguments:
 * 	Text - label string
 * 	func - pointer to signal handler
 * 	func_data - data for signal handler
 * Return value:
 * 	Pointer to create button
 * Description:
 * 	Create new button and link button with "clicked" signal handler
 */
GtkWidget *bf_stock_button (const gchar *Text, GtkSignalFunc func, gpointer func_data)
{
	GtkWidget *button;

	button = gtk_button_new_with_label (Text);
	g_return_val_if_fail (button, NULL);
	gtk_signal_connect(GTK_OBJECT(button), "clicked", func, func_data);
	DEBUG_MSG("bf_stock_button, func_data=%p\n", func_data);
	return button;
};

/*
 * Function: bf_stock_ok_button
 * Arguments:
 * 	func - pointer to signal handler
 * 	func_data - data for signal handler
 * Return value:
 * 	Pointer to create button
 * Description:
 * 	Create new "Ok" button
 */
GtkWidget *bf_stock_ok_button (GtkSignalFunc func, gpointer func_data)
{
	return bf_stock_button (_(" Ok "), func, func_data);
};

/*
 * Function: bf_stock_cancel_button
 * Arguments:
 * 	func - pointer to signal handler
 * 	func_data - data for signal handler
 * Return value:
 * 	Pointer to create button
 * Description:
 * 	Create new "Cancel" button
 */
GtkWidget *bf_stock_cancel_button (GtkSignalFunc func, gpointer func_data)
{
	return bf_stock_button (_(" Cancel "), func, func_data);
};
