<?php
# ---------------------------------------------------------------
# bookmarker
# A WWW based bookmark management, retrieval, and search tool.
# Copyright (C) 1998  Padraic Renaghan
# Licensed under terms of GNU General Public License
# (see http://www.renaghan.com/bookmarker/source/LICENSE)
# ---------------------------------------------------------------
# $Id: bklocal.inc,v 1.11 1999/07/12 21:00:25 prenagha Exp $
# ---------------------------------------------------------------
class bk_db extends DB_Sql {
  var $Host     = "localhost";
  var $Database = "bookmarks";
  var $User     = "user";
  var $Password = "pwd";
  
  var $Auto_Free     = 1;     ## Set to 1 for automatic mysql_free_result()
  var $Debug         = 0;     ## Set to 1 for debugging messages.
  var $Halt_On_Error = "yes"; ## "yes" (halt with message), 
	                            ## "no" (ignore errors quietly), 
															## "report" (ignore errror, but spit a warning)

  ## this function returns the auto increment
  ## value assigned to the primary key in the
  ## most recent insert of this connection.
  function insert_id() {
    return mysql_insert_id($this->Link_ID);
  }

}

class bk_ct_sql extends CT_Sql {
  var $database_class = "bk_db";           ## which database to connect
	var $database_table = "active_sessions"; ## find session data in this tbl
}

class bk_sess extends Session {
  var $classname      = "bk_sess";
  var $cookiename     = $classname;
  var $magic          = "8";      ## ID seed
  var $mode           = "cookie";          ## We propagate session IDs with cookies
  var $fallback_mode  = "get";
  var $lifetime       = 0;                 ## 0 = do session cookies, else minutes
  var $database_class = "bk_db";           ## Which database to connect...
  var $database_table = "active_sessions"; ## and find our session data in this table.

  var $gc_time  = 1440;                    ## Purge all session data older than 1440 minutes.
  var $gc_probability = 1;                 ## Garbage collect probability in percent

	
  var $allowcache     = "no";              ## if you want to allow caching
  var $allowcache_expire = 30;             ## cached pages expire in this many
	                                         ## minutes

	var $that_class = "bk_ct_sql";         ## Name of data storage container
}

class bk_sess_cache extends bk_sess {
#
# use this version of the bookmarker session object when
# we want to allow a page to be cached on the client
# side. for performance reasons in the bookmarker app,
# we want to cache at least the tree view page.
# when HTTP/1.1 is more prevalent, we will switch this
# to private caching.
#
  var $allowcache        = "public";
}

class bk_user extends User {
  var $classname  = "bk_user";
  var $magic      = "005";  ## ID seed
	var $that_class = "bk_ct_sql";     ## Name of data storage container
}

class bk_cr_auth extends Auth {
  var $classname      = "bk_cr_auth";
  var $lifetime       =  120;
  var $mode           = "log";         ## "log" for login only systems,
                                       ## "reg" for user self registration
  var $nobody         = false;         ## If true, a default auth is created...
  var $magic          = "735";  ## Challenge seed
	var $database_class = "bk_db";       ## Name of database class
  var $database_table = "auth_user";

  function auth_loginform() {
    global $sess;
    global $challenge;

    $challenge = md5(uniqid($this->magic));
    $sess->register("challenge");

    include("crlogin.inc");
  }
  
  function auth_validatelogin() {
    global $username, $password, $challenge, $response;

    $this->auth["uname"]=$username;   
    $this->db->query(sprintf("select uid, perms, password from %s where username = '%s'", $this->database_table, $username));

    while($this->db->next_record()) {
      $uid   = $this->db->f("uid");
      $perm  = $this->db->f("perms");
      $pass  = $this->db->f("password");
    }
    $expected_response = md5("$username:$pass:$challenge");


    ## True when JS is disabled
    if ($response == "") {
      if (md5($password) != $pass) {
        return false;
      } else {
        $this->auth["perm"] = $perm;
        return $uid;
      }
    }
    
    ## Response is set, JS is enabled
    if ($expected_response != $response) {
		  if (! empty($password)) {
        echo "<br><small><font color=red><strong>WARNING:</strong><br>Your browser has a buggy implementation of JavaScript that is<br> causing the plaintext password to be sent over the network!</font></small>";
		  }

      return false;
    } else {
      $this->auth["perm"] = $perm;
      return $uid;
    }
  }
}

class bk_perm extends Perm {
  var $classname = "bk_perm";
  var $permissions = array(
                            "guest"     => 1,
                            "editor"    => 3,
                            "admin"     => 7
                          );

  function perm_invalid($does_have, $must_have) {
    global $perm, $auth, $sess;
    include("bkperminvalid.ihtml");
  }
}

class bk_Sql_Query extends Sql_Query {
  var $classname = "bk_Sql_Query";
  var $persistent_slots = array(
    "conditions", "input_size", "input_max", "method", "lang", "translate", "container", "variable", "query"
  );
  var $query = "1=0";       ## last WHERE clause used
  var $conditions = 1;      ## Allow for that many Query Conditions
  var $input_size = 35;     ## Used in text input field creation
  var $input_max  = 80;

  var $method     = "post"; ## Generate get or post form...
  var $lang       = "en";   ## HTML Widget language

  var $translate = "on";    ## If set, translate column names
  var $container = "";      ## If set, create a container table
  var $variable  = "on";    ## if set, create variable size buttons
}
?>
