<?php 
# ---------------------------------------------------------------
# bookmarker
# A WWW based bookmark management, retrieval, and search tool.
# Copyright (C) 1998  Padraic Renaghan
# Licensed under terms of GNU General Public License
# (see http://www.renaghan.com/bookmarker/source/LICENSE)
# ---------------------------------------------------------------
# $Id: list.php3,v 1.10 1999/04/30 06:13:22 prenagha Exp $
# ---------------------------------------------------------------
include("bkprepend.php3");
page_open(array( "sess" => "bk_sess"
          ,"auth" => "bk_cr_auth"
          ,"perm" => "bk_perm"
          ,"user" => "bk_user"));
include("plist.inc");

$tpl->define(array(
  standard   => "common.standard.tpl",
  body       => "list.body.tpl",
  first       => "list.first.tpl",
  prev       => "list.prev.tpl",
  next       => "list.next.tpl",
  last       => "list.last.tpl",
  error_msg  => "common.error_message.tpl"
));

# get the session variable that stores the username
# most of the time it is equal to the username in the
# auth class, but if the guest user logs in, there
# username session variable is set to prenagha
set_bkusername(); 

# get/set the $user_last_page as a user variable.
# PHPLIB will store this value in the database linked
# to this user.
$user->register("user_last_page");

# if $user_total_bookmarks value is not defined that means
# that either this is the guest user, or this is the first time
# this user is going to this page and has not added/deleted
# a bookmark yet. In that case, get/set this value. Normally,
# this value is set since it is a PHPLIB user variable - it is
# set on the maintain.php3 and create.php3 pages when a bookmark
# is deleted or created respectively.
if ( ! isset($user_total_bookmarks) ) {
  # Get a database connection
  $db   = new bk_db;
  $query = sprintf("select count(*) as nbr_bookmarks from bookmark where username = '%s'", $bkusername);
  $db->query($query);
  if ($db->next_record()){
    $user_total_bookmarks = $db->f("nbr_bookmarks");
  }
  $got_count = TRUE;
}

# get the user defined nbr of bookmarks per page
# the local admin can set this to 0 if the database
# doesn't support the use of the "LIMIT offset, nbr"
# statement.
$limit = $bookmarker->urls_per_page;

# the first page is page one
$first_page = 1;

# calculate the page number of the last page
# (divide and round UP)
if ( $limit > 0 ) {
  $last_page = ceil($user_total_bookmarks / $limit);
} else {
  $last_page = $first_page;
}

# if page specified in URL, then use it
if ( $page > 0 ) {

# otherwise try and bring up the last page
# this user looked at.
} elseif ( $user_last_page > 0 ) {
	$page = $user_last_page;

# as a last resort, start at page 1
} else {
  $page = 1;
}


# if page greater than one then set first and prev page stuff
if ( $page > 1 ) {
  $first_url = sprintf("%s?page=%s", $sess->url("list.php3"), $first_page);
  $tpl->assign(FIRST_URL, $first_url);
  $tpl->parse(FIRST_LINK, "first");

  $prev_page = $page - 1;
  $prev_url = sprintf("%s?page=%s", $sess->url("list.php3"), $prev_page);
  $tpl->assign(PREV_URL, $prev_url);
  $tpl->parse(PREV_LINK, "prev");

# otherwise prev page stuff is null
} else {
  unset($prev_page);
}


$tpl->assign(PAGE_NBR, $page);
$tpl->assign(TOTAL_PAGES, $last_page);

# calculate the row offset (what row number do
# we start printing for this page - starts with
# zero)
$offset = ( ($page - 1) * $limit );

# if we are on the last page, set the limit to
# the max so that we can be sure we get everything
if ($page < $last_page ) {
  $last_url = sprintf("%s?page=%s", $sess->url("list.php3"), $last_page);
  $tpl->assign(LAST_URL, $last_url);
  $tpl->parse(LAST_LINK, "last");
	
  $next_page = $page + 1;
  $next_url = sprintf("%s?page=%s", $sess->url("list.php3"), $next_page);
  $tpl->assign(NEXT_URL, $next_url);
  $tpl->parse(NEXT_LINK, "next");
} else {
  unset($next_page);
	$limit = $user_total_bookmarks;
}

# store the last page this user looked at in
# a PHPLIB user var.
$user_last_page = $page;

print_list ($where_clause, $bkusername, $limit, $offset, &$bookmark_list);

$tpl->assign(BOOKMARK_LIST, $bookmark_list);

# print a start next to the count if we just calculated it.
if ( $got_count ) {
  $user_total_bookmarks = $user_total_bookmarks."*";
}

$tpl->assign(TOTAL_BOOKMARKS, $user_total_bookmarks);

set_standard("list ($page of $last_page)", &$tpl);

$tpl->parse(BODY, "body");
$tpl->parse(MAIN, "standard");
$tpl->FastPrint();

page_close();
?>
