#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <unistd.h>
#include <gtk/gtk.h>
#include <gtk-xmhtml/gtk-xmhtml.h>

#include "bwindow_callbacks.h"
#include "bwindow.h"
#include "alerts.h"
#include "express.h"
#include "browser.h"
#include "history.h"
#include "options.h"
#include "pipedialog.h"

extern app_kernel *ak;

void bwindow_back_callback(GtkWidget *widget, gpointer data)
{
  history_change(BWINDOW(data), BWINDOW(data)->history->parent);
}

void bwindow_forward_callback(GtkWidget *widget, gpointer data)
{
  history_change(BWINDOW(data), BWINDOW(data)->history->descendent);
}

void bwindow_home_callback(GtkWidget *widget, gpointer data)
{
  bwindow_set_url(BWINDOW(data), DEFAULT_HOME_URL);
}

void bwindow_reload_callback(GtkWidget *widget, gpointer data)
{
  bwindow_set_url(BWINDOW(data), BWINDOW(data)->current->url);
}

void bwindow_view_src_callback(GtkWidget *widget, gpointer data)
{
  g_print("%s\n", BWINDOW(data)->current->src);
}

void bwindow_edit_callback(GtkWidget *widget, gpointer data)
{
  char tmpfilename[64];
  char cmd[CMD_LEN];
  char cmd_str[CMD_LEN];
  FILE *f;
  char *src;
  int pid;

  if ( tmpnam(tmpfilename) == NULL ) {
    make_alert(widget, "Could not create temporary file.");
    return;
  }
    
  if((f=fopen(tmpfilename, "w"))==NULL) {
    make_alert(widget, "Could not create temporary file.");
    return;
  }

  src = BWINDOW(data)->current->src;
  fwrite(src, strlen(src), sizeof(char), f);
  fclose(f);

  /* cmd_str is to be set as a user option */
  sprintf(cmd_str, "/usr/X11/bin/xedit %%s");
  sprintf(cmd, cmd_str, tmpfilename);

  pid = fork();
  if(pid==0) {
    if(system(cmd)==127) {
      perror("Error executing editor (system)");
      unlink(tmpfilename);
      _exit(127);
    } else {
      unlink(tmpfilename);
      _exit(0);
    } 
  } else if (pid==-1) {
    make_alert(widget, "Could not execute editor command");
    return;
  }
}

void bwindow_pipe_callback(GtkWidget *widget, gpointer data)
{
  GtkWidget *pipedialog;

#if 0
  if(BWINDOW(data)->filesel != NULL)
    return;
#endif

  pipedialog = pipedialog_new("Pipe source through shell command:",
    BWINDOW(data)->current->src);
  gtk_widget_show(pipedialog);
}

void saveas_ok_callback(GtkWidget *widget, gpointer data)
{
  FILE *f;
  char msg[1024];
  char *src, *filename;

  filename = gtk_file_selection_get_filename(GTK_FILE_SELECTION(BWINDOW(data)->filesel));
  if((f=fopen(filename, "w")) != NULL) {
    src = BWINDOW(data)->current->src;
    fwrite(src, strlen(src), sizeof(char), f);
    fclose(f);
    gtk_widget_destroy(GTK_WIDGET(BWINDOW(data)->filesel));
    BWINDOW(data)->filesel = NULL;
  } else {
    sprintf(msg, "Error opening file %s", filename);
    make_alert(widget, msg);
  }

}

void saveas_cancel_callback(GtkWidget *widget, gpointer data)
{
  gtk_widget_destroy(GTK_WIDGET(BWINDOW(data)->filesel));
  BWINDOW(data)->filesel = NULL;
}

void saveas_help_callback(GtkWidget *widget, gpointer data)
{
}

void bwindow_saveas_callback(GtkWidget *widget, gpointer data)
{
  if(BWINDOW(data)->filesel != NULL)
    return;

  BWINDOW(data)->filesel = gtk_file_selection_new("Save As");
  gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(BWINDOW(data)->filesel)->ok_button), "clicked",
                     GTK_SIGNAL_FUNC(saveas_ok_callback), data);
  gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(BWINDOW(data)->filesel)->cancel_button), "clicked",
                     GTK_SIGNAL_FUNC(saveas_cancel_callback), data);
#if 0
  gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(BWINDOW(data)->filesel)->help_button), "clicked",
                     GTK_SIGNAL_FUNC(saveas_help_callback), data);
#endif
  gtk_widget_show(BWINDOW(data)->filesel);
}

void browse_ok_callback(GtkWidget *widget, gpointer data)
{
  char url[URL_LEN];

  sprintf(url, "file://%s", gtk_file_selection_get_filename(GTK_FILE_SELECTION(BWINDOW(data)->filesel)));
  bwindow_set_url(BWINDOW(data), url);
  g_print("%s\n", url);
  gtk_widget_destroy(GTK_WIDGET(BWINDOW(data)->filesel));
  BWINDOW(data)->filesel = NULL;
}

void browse_cancel_callback(GtkWidget *widget, gpointer data)
{
  gtk_widget_destroy(GTK_WIDGET(BWINDOW(data)->filesel));
  BWINDOW(data)->filesel = NULL;
}

void browse_help_callback(GtkWidget *widget, gpointer data)
{
}

void bwindow_browse_callback(GtkWidget *widget, gpointer data)
{
  if(BWINDOW(data)->filesel != NULL)
    return;

  BWINDOW(data)->filesel = gtk_file_selection_new("Browse local files");
  gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(BWINDOW(data)->filesel)->ok_button), "clicked",
                     GTK_SIGNAL_FUNC(browse_ok_callback), data);
  gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(BWINDOW(data)->filesel)->cancel_button), "clicked",
                     GTK_SIGNAL_FUNC(browse_cancel_callback), data);
#if 0
  gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(BWINDOW(data)->filesel)->help_button), "clicked",
                     GTK_SIGNAL_FUNC(browse_help_callback), data);
#endif
  gtk_widget_show(BWINDOW(data)->filesel);
}

void file_newbrowser_callback(GtkWidget *widget, gpointer data)
{
  express_clone_browser(BWINDOW(data));
#if 0
  GtkWidget *newbwindow;

  newbwindow = bwindow_new();
  gtk_widget_show(newbwindow);  

  BWINDOW(newbwindow)->history = BWINDOW(data)->history;
  if(bwindow_get_url(BWINDOW(data))) 
    bwindow_set_url(BWINDOW(newbwindow), bwindow_get_url(BWINDOW(data)));
#endif
}

void file_close_cmd_callback(GtkWidget *widget, gpointer data)
{
  express_close_browser(BWINDOW(data));
#if 0
  gtk_widget_destroy(GTK_WIDGET(data));
  num_bwindows--;
  if(num_bwindows==0) {
    cleanexit(0);
  }
#endif
}

void file_quit_cmd_callback (GtkWidget *widget, gpointer data)
{
    cleanexit(0);
}

void bwindow_toolbar_icons(GtkWidget *widget, gpointer data)
{
  gtk_toolbar_set_style(GTK_TOOLBAR(BWINDOW(data)->tb1), GTK_TOOLBAR_ICONS);
  gtk_toolbar_set_style(GTK_TOOLBAR(BWINDOW(data)->tb2), GTK_TOOLBAR_ICONS);
}

void bwindow_toolbar_text(GtkWidget *widget, gpointer data)
{
  gtk_toolbar_set_style(GTK_TOOLBAR(BWINDOW(data)->tb1), GTK_TOOLBAR_TEXT);
  gtk_toolbar_set_style(GTK_TOOLBAR(BWINDOW(data)->tb2), GTK_TOOLBAR_TEXT);
}

void bwindow_toolbar_both(GtkWidget *widget, gpointer data)
{
  gtk_toolbar_set_style(GTK_TOOLBAR(BWINDOW(data)->tb1), GTK_TOOLBAR_BOTH);
  gtk_toolbar_set_style(GTK_TOOLBAR(BWINDOW(data)->tb2), GTK_TOOLBAR_BOTH);
}

void gtk_xmhtml_click(GtkWidget *widget, gpointer data)
{
/*  BWindow *bwindow;*/

  XmHTMLAnchorCallbackStruct *cbs =
    (XmHTMLAnchorCallbackStruct *)(data);

  g_print("Should probably set the url to %s\n", cbs->href);

  /** get bwindow **/
  /*bwindow_set_url(BWINDOW(bwindow), cbs->href);*/
#ifdef MULTIPLE_WINDOWS
  /* feel free to hack this to work in the current framework!! */
#else
  bwindow_set_url(BWINDOW(ak->browser), cbs->href);
#endif
}
