package HNS::Hnf::TreeBuilder;
################################################################
# HNS::HnfTreeBuilder;
#
#  parse the hnf, and construct tree-structure
#
# $Id: TreeBuilder.pm,v 1.11.2.3 2000/02/13 14:23:12 kenji Exp $
################################################################

use strict qw(vars);
use Image::Size;                # CAT image
use HNS::Hnf::Command;
use HNS::Hnf::Warning;
use HNS::Template;
use HNS::CategoryList;
use HNS::System;

BEGIN{
#    print "content-type: text/html\n\n";
}
#@HNS::Hnf::TreeBuilder::ISA = qw(HNS::Hnf::Command::HNF);

################################################################
sub new ($)
{
    my $class = shift;
    my $self = {
	top=>new HNS::Hnf::Command::HNF('HNF')    # top element of parse tree
	};
    bless $self, $class;
}
################################################################
sub Parse($$)
{
    my ($self, $line) = @_;

    # comment
    if ($line =~ /^!\#\s/){
	return;
    } elsif ($line =~ /^!\s/){
	$line = "<!-- $line -->\n";
    }
    # translate ~ to <BR>
    $line =~ s/~$/<br>/;
    if ($line =~ m!^(/?[A-Z]+)\s(.*)$!){    # may be hnf-command
	my $cmd_name = $1;
	my $is_end = $cmd_name =~ s!^/!!;
	my @vars = ($cmd_name, split(/ /, $2));
	if (!$is_end){
	    $self->start(@vars);          # start command. ex) UL
	} else {
	    $self->end(@vars);            # end command. ex) /UL
	}
    } else {                              # plain text
	$self->text($line);
    }
}
# private:
# if start command apeared,
# first create new command object($e),
# second insert the object to valid position of the tree($self->{pos}).
#
# (*) checking command validation and placement.
#     insert end tag when the command could be omit end-command.
sub start($@)
{
    my ($self, @vars) = @_;

    my $cmd_name = $vars[0];
    my $e;
    my $pos = $self->{top}->{pos} || $self->{top};
    my $class = "HNS::Hnf::Command::$cmd_name";
    eval("\$e = new $class(qq($cmd_name));");
    if ($@){    # invalid command
	$pos->PushContent(join(' ', @vars));
	$pos->PushContent("\n");
	$pos->PushContent(HNS::Hnf::Warning::Message('Reserved', $cmd_name))
	    unless ($HNS::System::IgnoreReserved eq 'ON');
	return;
    }
    # set attributes and element to new Command
    {
	my $n_attr = "${class}::NumAttr";
	# if line is "LINK url explain of anchor", and $n_attr == 1,
	# $e->{attr} = ['LINK', 'url']
	# $e->{arg_content} = 'explain of ahchor';
	$n_attr = $$n_attr;
	$e->{attr} = [@vars[0..$n_attr]];
	$e->{arg_content} = join(' ', @vars[$n_attr+1..$#vars]);
    }
    # check structure
    {
	my $pos_name = $pos->{name};

#	print "start["  . $pos->{name} . "]: @vars<br>\n";
	# check allowed
	if (!$pos->allowed($cmd_name)){
	    if ($pos_name ne $cmd_name && !$pos->OmittableEnd){
		$pos->PushContent(HNS::Hnf::Warning::Message('NoMatch',
							     $cmd_name,
							     $pos_name));
	    }
	    # complete end command automatically if omittable
	    $self->end($cmd_name);
#	    print "end: $pos_name,", $p->{name}, ",", $e->{name}, ",", $e->{parent}->{name}, "<br>";
	}

	# CAT must have only one New element
	if ($e->IsBeginSection && $pos->{name} ne 'CAT'){
#	    print $e->{name};
	    $self->{top}->InsertCommand('CAT');
	}
#	print "$cmd_name in $pos_name<br>";
    }
    # insert new command
    $self->{top}->InsertCommand($e);

    # if oneline command, insert end tag immidiately
    if ($e->IsOneline){
#	print STDERR "oneline:$cmd_name\n";
	$self->end($cmd_name);
    }
}
# private:
sub end($$)
{
    my ($self, $cmd_name) = @_;
#    print STDERR "end: $cmd_name\n";
    my $p = $self->{top}->{pos} || $self;

    $cmd_name =~ s/^L(NEW|SUB)/$1/;
    
    # enclose until self tag
    while (defined $p){
	my $p_name = $p->{name};
	$p_name =~ s/^L(NEW|SUB)/$1/;
#	last if $p->{name} =~ /$cmd_name/;
	last if $p_name eq $cmd_name;
	$p = $p->{parent};
    }
    $self->{top}->{pos} = (defined $p) ?
	$p->{parent} : $self->{top}->{pos}->{parent};
}
# plain text
# private:
sub text($$)
{
    my ($self, $text) = @_;
    my $pos = $self->{top}->{pos} || $self->{top};
#    print STDERR "text[" . $pos->{name} . "]:$text";
    $pos->PushContent($text);
}

################################################################
sub Print($$$$)
{
    my ($self, $year, $month, $day) = @_;
    my $html;

    # for footnote
    my $in_fn = 0;
    my @footnotes;

    # for eval template
    my ($newCount, $subCount, $fnCount);
    my $abc;
    if ($day < 11) {
        $abc = "a";
    }
    elsif ($day < 21) {
        $abc = "b";
    }
    else {
        $abc = "c";
    }
    my $code_params = q({year=>$year, month=>$month, day=>$day,
			 high=>int($day/10), abc=>$abc,
			 new=>$newCount, sub=>$subCount, fn=>$fnCount,
			 cat=>$cat});

    # category presentation
    my $cat;

    # traverse the tree-structure and print
    # FN, /FN and CAT is special command
    $self->{top}->Traverse(sub {
	my ($node, $start, $depth) = @_;
	if (ref $node){            # HNF command
	    my $name = $node->{name};
	    if ($name eq 'FN'){    # FN command
		if ($start){
		    $fnCount++;
		}
		$in_fn = $start;   # whether $node is content of FN
		print $node->AsHTML($start, eval($code_params));
	    } else {               # else command
		if ($HNS::CategoryList::CatDir && $name eq 'CAT' && $start){
		    $cat = get_category($node->{arg_content});
		}
		if ($in_fn){
		    $footnotes[$fnCount] .= $node->AsHTML($start,
							  eval($code_params));
		} else {
		    my $count_name;
		    if ($start && ($count_name = $node->CountName)){
			my $code = "\$${count_name}Count++;";
			eval($code);
		    }
		    # beginning of section : NEW, SNEW
#		    print "node:", $node->{name}, ",$start,";
#		    print $node->{parent}->{name}, "<br>";
		    if (!$start && $node->IsBeginSection){
			# clear count
			$subCount = 0;
			$fnCount = 0 if ($HNS::System::FNCountStyle == 0);
			# if current section has any FN content,
			# print it in here.
			if (@footnotes){
			    my $params = eval($code_params);
			    print_footnote($params, @footnotes);
			    # reset footnotes
			    @footnotes = ();
			}
		    }
		    print $node->AsHTML($start, eval($code_params));
		}
	    }
	} else {                        # plain text
	    if ($in_fn){
		$footnotes[$fnCount] .= $node;
	    } else {
		print $node;
	    }
	}1;});
    return;
}

sub get_category ($)
{
    my $arg_content = shift;
    my $cat;
    # CAT arg1 arg2 arg3..
    for my $c (split(/ /, $arg_content)){
	my $img;
	if ($img = $HNS::CategoryList::DB{$c}){
	    my $src = "$HNS::CategoryList::CatDir/$img";
	    my ($width, $height) = imgsize($src);
	    $cat .= qq(<img src="$src" width="$width" height="$height" alt="[$c]">);
	} elsif ($c) {
	    my $templ = new HNS::Template;
	    $cat .= $templ->Expand($HNS::Hnf::Command::CAT::template,
				   {var=>$c});
	    $cat .= "[$c]";
	    
	}
    }
    return $cat;
}
sub print_footnote ($@)
{
    my ($params, @footnotes) = @_;
    
    my $templ = new HNS::Template;
    $templ->SetParamValues(%$params);
    # fn header
    $templ->SetTemplate
	($HNS::Hnf::Command::FN::HeaderTemplate);
    print $templ->Expand;
    # fn content
    my $cnt;
    for (@footnotes[1..$#footnotes]){
	$cnt++;
	next if (($_ eq "") && ($HNS::System::FNCountStyle));
	$templ->SetTemplate
	    ($HNS::Hnf::Command::FN::ContentTemplate);
	$templ->SetParamValues('fn'=>$cnt);
	$templ->SetParamValues('content'=>$_);
	print $templ->Expand;
    }
    # fn footer
    $templ->SetTemplate
	($HNS::Hnf::Command::FN::FooterTemplate);
    print $templ->Expand;
}
1;


