package HNS::PIM::Schedule;
################################################################
# HNS::PIM::Schedule : Schedule Manager
#
# usage:
# my $sch = new HNS::PIM::Schedule(dir=>'diary');
# $sch->Read;
# print $sch->AsHTML;
#
# $Id: Schedule.pm,v 1.6 1999/04/17 18:16:55 kenji Exp $
################################################################
use strict;
require 'jcode.pl';
use ObjectTemplate;
@HNS::PIM::Schedule::ISA = qw(ObjectTemplate);

use HNS;
use HNS::System;
use HNS::Template;

attributes qw(contents error);

################################################################
use vars qw($MaxNum $ContentTemplate $BeginTemplate $EndTemplate @WeekString);

$MaxNum = 8;                # max number of showing
@WeekString = ('Sun', 'Mon', 'Tue', 'Wed', 'Thr', 'Fri', 'Sat');

# template
$ContentTemplate = qq(<li><strong>%month/%day(%week)</strong> %content</li>\n);
$BeginTemplate = "<ul>";
$EndTemplate = "</ul>";

sub initialize($)
{
    my $self = shift;
    $self->contents([]);
}
################################################################
sub Read ($)
{
    my $self = shift;
    use DateTime::Date;
    my $date = new DateTime::Date;
    $date->year($HNS::Status->start_time->year);
    $date->month($HNS::Status->start_time->month);
    $date->day($HNS::Status->start_time->day);

    # collect reading file
    my @files;
    # this month
    @files = ($self->get_files($date),
	      $self->get_files($date+='1M'));
		
	    
    # next month
    $date += '1M';
    push(@files,
	 sprintf("%s/y%04d%02d",
		 $HNS::System::DiaryDir, $date->year, $date->month),
	 sprintf("%s/%04d/y%04d%02d",
		 $HNS::System::DiaryDir,
		 $date->year, $date->year, $date->month));

#    print "content-type: text/html\n\n";

    # read yotei files
    for my $file (@files){
	# read file
	open(F, $file) || next;
#	print "$file, ";
	# set default year, month
	my ($y, $m) = $file =~ /y(\d{4})(\d{2})$/;
	
	# read content
	while (<F>){
	    next if /^$/;
	    &jcode::convert(*_, 'euc');
	    my ($num, $content) = /^([\d\/]+)\s(.*)$/;
	    my $date = new DateTime::Date(year=>$y, month=>$m);
	    if ($num =~ m!^(\d+)/(\d+)!){      # 03/31 content..
		$date->month($1), $date->day($2);
	    } else {                           # 31 content..
		$date->day($num);
	    }
	    push(@{$self->contents}, {date=>$date, content=>$content});
	}
	close F;
    }
    closedir(DIR);
}

sub AsHTML($)
{
    my $self = shift;
    my $templ = new HNS::Template;
    my $cnt;
    my $html;

    my $now_date = $HNS::Status->start_time;
    $html .= $BeginTemplate;
    
    my $until_date = new DateTime::Date(year=>$now_date->year,
					month=>$now_date->month,
					day=>$now_date->day);
    $until_date += '1M';
    # error check
    if ($self->error){
	$html .= $self->error;
    }
    for (sort {$a->{date} <=> $b->{date}} @{$self->contents}){
	next unless $now_date <= $_->{date} &&     # now and future
	    $until_date > $_->{date};              # until next month
	last if ++$cnt > $MaxNum;                  # less than equal $MaxNum
	$html .= $templ->Expand($ContentTemplate,
				{year=>sprintf("%04d", $_->{date}->year),
				 month=>sprintf("%02d", $_->{date}->month),
				 day=>sprintf("%02d", $_->{date}->day),
				 week=>$WeekString[$_->{date}->week],
				 content=>$_->{content}});
    }
    $html .= $EndTemplate;
}
################################################################
# private:
sub get_files($$)
{
    my ($self, $date) = @_;
    my @files;
    
    my $file_flat = sprintf("%s/y%04d%02d",
			    $HNS::System::DiaryDir,
			    $date->year, $date->month);
    my $file_year = sprintf("%s/%04d/y%04d%02d",
			    $HNS::System::DiaryDir,
			    $date->year, $date->year, $date->month);
    if (-f $file_flat){
	if (-f $file_year){
	    $self->set_error("Dupricate: $file_flat, $file_year");
#	    die "Dupricate: $file_flat, $file_year";
	}
	push(@files, $file_flat);
    } elsif (-f $file_year){
	push(@files, $file_year);
    }
    return @files;
}

sub set_error($$){
    my ($self, $msg) = @_;
    
    $self->error($msg);
}
1;
