package HNS::PIM::Todo;
################################################################
# HNS::PIM::Todo : Todo Manager
#
# usage:
# my $todo = new HNS::PIM::Todo(filename=>'diary/todo');
# $todo->Read;
# print $todo->AsHTML;
#
# $Id: Todo.pm,v 1.6 1999/04/25 11:30:50 kenji Exp $
################################################################
use strict;
use ObjectTemplate;
@HNS::PIM::Todo::ISA = qw(ObjectTemplate);

use HNS::System;
use HNS::Template;

attributes qw(contents);

use vars qw($MaxNum $ContentTemplate $BeginTemplate $EndTemplate);

$MaxNum = 8;

# template
$ContentTemplate = "<li><strong>%priority</strong> %content</li>\n";
$BeginTemplate = "<ul>";
$EndTemplate = "</ul>";

sub initialize($)
{
    my $self = shift;
    $self->contents([]);
}
################################################################
sub Read ($)
{
    my $self = shift;
    my $filename = "$HNS::System::DiaryDir/todo";
    open(F, $filename) || return;
    while (<F>){
	next if /^$/;
	&jcode::convert(*_, 'euc');
	/^(\d+)\s(.*)$/;
	push(@{$self->contents},
	     {priority=>sprintf("%02d",$1), content=>$2});
    }
    close F;
}
sub AsHTML ($)
{
    my $self = shift;
    my $templ = new HNS::Template;
    my $html .= $BeginTemplate;
    my $cnt;    

    for (sort {$b->{priority} <=> $a->{priority}} @{$self->contents}){
	last if ++$cnt > $MaxNum;
	$html .= $templ->Expand($ContentTemplate,
				{priority=>$_->{priority},
				 content=>$_->{content}});
    }
    $html .= $EndTemplate;
}
	
1;
