#ifndef SCREEM_PAGE_H
#define SCREEM_PAGE_H

#include <glib.h>

typedef struct _Page {
	gchar *pathname;     /* pathname for the page */
        gchar *data;         /* the actual page data */
	gint tab;            /* the tab number of the page if open */
} Page;

Page *screem_page_new( void );
void screem_page_destroy( Page *page );

void screem_page_set_pathname( Page *page, const gchar *path );
const gchar *screem_page_get_pathname( Page *page );

void screem_page_set_tab( Page *page, gint num );
gint screem_page_get_tab( Page *page );

Page *screem_page_from_tab_num( GList *list, gint num );
void screem_page_update_tab_nums( GList *list, gint num );

gboolean screem_page_read( Page *page, int fd );
gboolean screem_page_load( Page *page );
gboolean screem_page_revert( Page *page );
gboolean screem_page_save( Page *page );
void screem_page_set_editor( Page *page, gpointer editor );
gpointer screem_page_get_editor( Page *page );

#endif
