/*  Screem:  uploadWizard.h,
 * 
 *  This file Copyright (C) 1999 Lee Mallabone.
 *  Original 'sitecopy' by Joe Orton.
 *  Sitecopy functionality integrated into transfer.c by Lee Mallabone.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  For contact information with the author of this source code please see
 *  the AUTHORS file.  If there is no AUTHORS file present then check the
 *  about box under the help menu for a contact address
 */

void upload_button_clicked                  (GtkButton       *button,
					     gpointer         user_data);

void error_button_clicked                  (GtkButton       *button,
					    gpointer         user_data);

void close_button_clicked                   (GtkButton       *button,
					     gpointer         user_data);

void create_update_dialog (void);
void create_error_log_window (void);
void uploadSite(void);
void *update_thread(void *bler);

void fe_connection( fe_conn_status status );
bool fe_can_update (const struct site_file_t *file);
void fe_updating (const struct site_file_t *file);
void fe_updated (const struct site_file_t *file, const bool success,
		 const char *error);
void fe_transfer_progress (size_t progress, size_t total);
void fe_synching( const struct site_file_t *file );
void fe_synched( const struct site_file_t *file, const bool success,
		const char *error );
void fe_fetch_found( const struct site_file_t *file );
