// This may look like C code, but it is really -*- C++ -*-

// <copyright>
// 
// Copyright (c) 1993-1997
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
// 
// </copyright>

//<file>
//
// Name:       hgwhat.C
//
// Purpose:    parse hyperg what string
//
// Created:    30 Jan 1997 Juergen Schipflinger
//
// $Id: hgwhat.C,v 1.1 1997/02/04 09:17:58 bmarsch Exp $
//
// Description:
//
//</file>

#include "hgwhat.h"
#include <hyperg/utils/hgregexp.h>

void HGWhat::setWhat(const RString& what)
{
  static HgRegexp reg_info = "@\\(#\\)\\[(Hyper-G|HyperWave)\\][ \t]+" // base
                             "\\[([-A-Za-z_]+)\\]" // type
                             "[ \t]+"
                             "([-A-Za-z_\\(\\)\\.]+)" // name
                             "[ \t]+"
                             "([0-9]+\\.[0-9]+)" // version
                             "([ A-Za-z0-9\\.\t]*)" // additional
                             "[ \t]+\\[([-&,;A-Za-z0-9_ \t\\./]+)\\]" // description
                             "[ \t]+"
                             "\\[([-@&,;A-Za-z0-9_ \t\\./]+)\\]"; // author
     
     // @ (#)[Hyper-G] [HGS-LS] hgserver  1.44 [server module] [Gerald Pani]
     // @ (#)[HyperWave] [HGS-LS] hgserver  1.44 [server module] [Gerald Pani]

  what_= what;

  if (reg_info.Match( what_, what_.length(), 0) > 0) {
    base_ = what_.gSubstrIndex( reg_info.BeginningOfMatch(1),reg_info.EndOfMatch(1) -1);
    type_ = what_.gSubstrIndex( reg_info.BeginningOfMatch(2),reg_info.EndOfMatch(2) -1);
    name_ = what_.gSubstrIndex( reg_info.BeginningOfMatch(3),reg_info.EndOfMatch(3) -1);
    version_ = what_.gSubstrIndex( reg_info.BeginningOfMatch(4),reg_info.EndOfMatch(4) -1);
    additional_ = what_.gSubstrIndex( reg_info.BeginningOfMatch(5),reg_info.EndOfMatch(5) -1);
    descr_ = what_.gSubstrIndex( reg_info.BeginningOfMatch(6),reg_info.EndOfMatch(6) -1);
    author_ = what_.gSubstrIndex( reg_info.BeginningOfMatch(7),reg_info.EndOfMatch(7) -1);
    ok_=true;
  }
  else
  {
    ok_=false;
  }
}
