/*
 * dsock.c - PTX socket processing functions for lsof
 */


/*
 * Copyright 1995 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1995 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dsock.c,v 1.3 96/01/11 12:55:09 abe Exp $";
#endif


#include "lsof.h"


/*
 * process_socket() - process socket
 */

void
process_socket(pn, fam, ipid, pa)
	char *pn;			/* protocol name */
	int fam;			/* address family (AF_*) */
	int ipid;			/* IP protocol ID (IPPROTO_*) &/
	KA_T pa;			/* kernel PCB address */
{
	char *cp, dev_ch[32];
	struct inpcb pcb;
	struct tcpcb tcb;

	Namech[0] = '\0';
	if (!Fsize)
		Lf->off_def = 1;
/*
 * Enter protocol name and address.
 */
	(void) strcpy(Lf->iproto, pn);
	Lf->inp_ty = 2;
	if (pa) {
	    (void) sprintf(dev_ch, "0x%08x", pa);
	    enter_dev_ch(dev_ch);
	}
/*
 * Process protocols.
 */
	switch (fam) {
	case AF_INET:
	    (void) strcpy(Lf->type, "inet");
	    if (Fnet)
		Lf->sf |= SELNET;
	/*
	 * Read IP protocol control block.
	 */
	    if (pa) {
		if (kread(pa, (char *)&pcb, sizeof(pcb))) {
		    (void) sprintf(Namech, "%s: can't read PCB from %#x",
			pn, pa);
		    enter_nm(Namech);
		    return;
		}
	    } else {
		(void) sprintf(Namech, "%s: no protocol control block", pn);
		enter_nm(Namech);
		return;
	    }
	    switch(ipid) {
	    case IPPROTO_TCP:
	    case IPPROTO_UDP:
		printinaddr((struct in_addr *)&pcb.inp_laddr,
		    (int)ntohs(pcb.inp_lport));
		if (pcb.inp_faddr != INADDR_ANY || pcb.inp_fport != 0) {
		    cp = endnm();
		    if ((MAXPATHLEN - 1 - (cp - Namech)) >= 2)
			(void) strcat(cp, "->");
		    printinaddr((struct in_addr *)&pcb.inp_faddr,
			(int)ntohs(pcb.inp_fport));
		}
		if (ipid == IPPROTO_TCP && !Fsize && pcb.inp_ppcb
		&&  kread((KA_T)pcb.inp_ppcb, (char *)&tcb, sizeof(tcb)) == 0)
		    Lf->off = (unsigned long)tcb.snd_nxt;
		break;
	    default:
		(void) sprintf(Namech,
		    "%s: unknown IP ID (%d) for AF_INET family", pn, ipid);
	    }
	    break;
	default:
	    (void) strcpy(Lf->type, "sock");
	    (void) sprintf(Namech, "%s: unknown family (%d) for IP ID %d",
		pn, fam, ipid );
	}
	if (Namech[0])
	    enter_nm(Namech);
}
