/*
 * dstore.c - Ultrix global storage for lsof
 */


/*
 * Copyright 1994 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1994 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dstore.c,v 1.3 95/02/10 10:37:30 abe Exp $";
#endif


#include "lsof.h"


/*
 * Global storage definitions
 */

int Kmem = -1;				/* /dev/kmem file descriptor */

int Mem = -1;				/* /dev/mem file descriptor */

struct nlist Nl[] = {

#if    ULTRIXV==20200
	{ "_proc"		},
	{ "_nproc"		},
	{ "_nch"		},
	{ "_nchsize"		},
	{ "_nfs_gnode_ops"	},
#else	/* ULTRIX!=20200 */
# if	defined(VAXULTRIX)
	{ "_proc"		},
	{ "_nproc"		},
	{ "_nch"		},
	{ "_nchsize"		},
	{ "_NFS_gnode_ops"	},
	{ "_Cdfs_gnode_ops"	},
	{ "_FIFO_gnode_ops"	},
	{ "_SPEC_gnode_ops"	},
	{ "_Ufs_gnode_ops"	},
# else	/* !defined(VAXULTRIX) */
	{ "proc"		},
	{ "nproc"		},
	{ "nch"			},
	{ "nchsize"		},
	{ "NFS_gnode_ops"	},
	{ "Cdfs_gnode_ops"	},
	{ "FIFO_gnode_ops"	},
	{ "SPEC_gnode_ops"	},
	{ "Ufs_gnode_ops"	},
# endif	/* defined(VAXULTRIX) */
#endif	/* ULTRIX==20200 */
	{ ""			}
};

int Swap = -1;				/* swap device file descriptor */
