/*
 * snd.c
 *
 * Conversion snd <--> Raw Modem Data
 *
 * Torsten Duwe <duwe@informatik.uni-erlangen.de>
 *
 */

#include "../include/voice.h"

char *snd_c = "$Id: snd.c,v 1.3 1996/07/25 19:22:08 marc Exp $";

typedef int codefunc _PROTO((int, int, FILE*, FILE*));

extern codefunc pvftozyxel, sndtorockw, rockwtosnd, zyxeltopvf;
extern read_snd_hdr _PROTO((FILE *, int *, int *));
extern write_snd_hdr _PROTO((FILE *, int, int));

int read_rmd_hdr _P4((mdmtype, nbits, rom, in), char **mdmtype,
               int *nbits, int *rom,
               FILE *in)
{
     rmd_header header;

     if (fread(&header, sizeof(rmd_header), 1, in) != 1)
          {
          lprintf(L_ERROR, "%s: Could not read header", program_name);
          return(FAIL);
          };

     if (strncmp(header.magic, "RMD1", 4) != 0)
          {
          lprintf(L_ERROR, "%s: No raw modem data header found",
           program_name);
          return(FAIL);
          }
     else
          lprintf(L_NOISE, "%s: raw modem data header found",
           program_name);

     lprintf(L_NOISE, "%s: modem type %s found", program_name,
          header.voice_modem_type);

     *mdmtype = strdup(header.voice_modem_type);
     *nbits = ntohs(header.compression);
     lprintf(L_NOISE, "%s: compression method 0x%04x", program_name,
      nbits);
/*
     *rom = ? ? ? ; XXX sollte besser auch im RMD-Header kodiert werden.
 */
     return(OK);
}
int write_rmd_hdr _P4((mdmtype, nbits, rom, out), char *mdmtype,
               int nbits, int rom,
               FILE *out)
{
     rmd_header header;

     memset(&header, 0x00, sizeof(rmd_header));
     sprintf(header.magic, "%s", "RMD1");
     sprintf(header.voice_modem_type, mdmtype);
     header.compression = htons(nbits);
/*
     header.??? = rom;
 */

     if (fwrite(&header, sizeof(rmd_header), 1, out) != 1)
          {
          lprintf(L_ERROR, "%s: Could not write header", program_name);
          return(FAIL);
          };
     return(OK);
}

int rmdtosnd _P2((argc, argv), int argc, char **argv)
{
     FILE *in = stdin;
     FILE *out = stdout;
     int result = FAIL;
     int nbits;
     char * type;

     voice_config("pvf", "");

     if (read_rmd_hdr(&type, &nbits, &rom_release, in) != OK)
       {
          lprintf(L_ERROR, "%s: Could not read header", program_name);
          return(FAIL);
       }

     if (argc >= 2)
          {

          if (strcmp(argv[1], "-r601") == 0)
               rom_release = 601;
          else if (strcmp(argv[1], "-r610") == 0)
               rom_release = 610;
          else if (strcmp(argv[1], "-r612") == 0)
               rom_release = 612;
          else
               USAGE("[-r612|-r610|-r601]");

          };

     if (!strcmp(type, "Rockwell"))
          result = rockwtosnd(nbits, rom_release, in, out);
     else if (!strcmp(type, "ZyXEL 1496"))
       {
      write_snd_hdr(out, 9600, 0);
      result = zyxeltopvf(nbits, rom_release, in, out);
       }

     free(type);
     return(result);
};

int sndtormd _P2((argc, argv), int argc, char **argv)
{
     FILE *in = stdin;
     FILE *out = stdout;
     int result = FAIL;
     int nbits;
     int srate, encoding;

     voice_config("pvf", "");

     if (argc >= 2)
          {

          if (strcmp(argv[1], "-r601") == 0)
               rom_release = 601;
          else if (strcmp(argv[1], "-r610") == 0)
               rom_release = 610;
          else if (strcmp(argv[1], "-r612") == 0)
               rom_release = 612;
          else
               USAGE("[-r612|-r610|-r601]");

          };

     nbits = argv[0][strlen(argv[0]) - 1] - '0';
     if (nbits > 4 || nbits < 2) nbits = 3;

     encoding=0;         /* want default encoding */
     srate = -1;         /* don't care what rate */
     if (read_snd_hdr(in, &srate, &encoding) != OK)
       {
          lprintf(L_ERROR, "%s: Could not read header", program_name);
          return(FAIL);
       }

     if (srate == 7200)       /* Rockwell */
          result = sndtorockw(nbits, rom_release, in, out);
     else if (srate == 9600)  /* Zyxel */
          result = pvftozyxel(nbits, rom_release, in, out);
     else
     {
     lprintf(L_ERROR, "%s: invalid sampling rate %d", program_name, srate);
     result = FAIL;
     }

     return(result);
};
