
/* Written by Peter Ekberg, peda@lysator.liu.se */

#include <stdlib.h>
#include <stdio.h>
#include <vga.h>
#include <vgagl.h>
#include <vgakeyboard.h>
#include <malloc.h>
#include "thrust.h"

void
turnship()
{
  word i,j,k;

  for(k=0; k<4; k++)
    for(i=0; i<16; i++)
      for(j=0; j<16; j++)
	*(ship+(5+k)*256 +     i*16+j)=
	  *(ship+(3-k)*256 +(15-j)*16+15-i);
  for(i=0; i<4; i++) {
    memcpy(shipstorage,ship+(i<<8),256);
    memcpy(ship+(i<<8),ship+((8-i)<<8),256);
    memcpy(ship+((8-i)<<8),shipstorage,256);
  }
  for(k=0; k<8; k++)
    for(i=0; i<16; i++)
      for(j=0; j<16; j++)
	*(ship+(9+k)*256 +     i*16+j)=
	  *(ship+(7-k)*256 +     i*16+15-j);
  for(k=0; k<15; k++)
    for(i=0; i<16; i++)
      for(j=0; j<16; j++)
	*(ship+(17+k)*256+     i*16+j)=
	  *(ship+(15-k)*256+(15-i)*16+j);
}

void
makeshieldedship()
{
  word i,j,k;

  memcpy(shieldship, ship, 8192);
  for(i=0; i<32; i++)
    for(j=0; j<16; j++)
      for(k=0; k<16; k++)
	if(*(bin_shield+(j<<4)+k))
	  *(shieldship+(i<<8)+(j<<4)+k)=*(bin_shield+(j<<4)+k);
}

void
makefuelmap(fuelmap)
     dword *fuelmap;
{
  int i;

  for(i=0; i<32; i++)
    {
      *(fuelmap+i+32)=255UL<<((i>6)+(i>16)+(i>26))*8;
      *(fuelmap+i)=255UL<<((i<27)+(i<17)+(i<7))*8;
    }
}

int
initmem()
{
  int i;

  bild=(byte *)malloc((long)PBILDX*PBILDY*2+16);
  bana=(byte *)malloc(maxlenx*maxleny);
  ship=(byte *)malloc(8192);
  shieldship=(byte *)malloc(8192);
  shipstorage=(byte *)malloc(256);
  bulletmap=(byte *)malloc(256);
  bulletstorage=(byte *)malloc(maxbullets*16);
  fragmentstorage=(byte *)malloc(maxfragments*4);
  fuelmap=(byte *)malloc(256);
  fuelstorage=(byte *)malloc(256);
  loadmap=(byte *)malloc(64);
  loadstorage=(byte *)malloc(64);
  wirestorage=(byte *)malloc(64);

  printf("Allocating memory...");

  if(!bana || !bild || !ship || !shieldship || !shipstorage ||
     !bulletmap || !bulletstorage || !fuelmap || !fuelstorage ||
     !loadmap || !loadstorage || !fragmentstorage) {
    printf("failed!.\n");
    return(0);
  }
  printf("done.\n");

  blocks=bin_blocks;
  memcpy(ship, bin_ship, 256*5);
  for(i=0; i<16; i++)
    memcpy(bulletmap+((20-i)&15)*16, bin_bullets+i*16, 16);

  printf("Turning the ship...");
  turnship();
  printf("done.\n");
  printf("Building graphics...");
  makefuelmap((dword *)fuelmap);
  memcpy(loadmap, blocks+64*109, 64);
  makeshieldedship();
  printf("done.\n");

  return(1);
}

void
inithardware()
{
  vga_init();
  if(!vga_hasmode(VGAMODE)) {
    printf("Graphics mode is not available.\n");
    exit(-1);
  }
  vga_setmode(VGAMODE);
  gl_setcontextvga(VGAMODE);
  
  palette=(Palette *)bin_colors;
  fadepalette(0,255,palette,1,0);

  if(keyboard_init()) {
    printf("Could not initialize the keyboard.\n");
    exit(-1);
  }
  printf("Keyboard initialized.\n");
}

void
initscreen(int round)
{
  int i,j;

  if(round&2) {
    palette->color[65].red  =0;
    palette->color[65].green=0;
    palette->color[65].blue =0;
  }
  else {
    palette->color[65].red  =colorr;
    palette->color[65].green=colorg;
    palette->color[65].blue =colorb;
  }

  for(j=pblocky; j<BBILDY+pblocky; j++)
    for(i=pblockx; i<BBILDX+pblockx; i++)
      writeblock(i%lenx, j, *(bana+i%lenx+j*lenx));
}

void
initgame(int round, int reset, int xblock, int yblock)
{
  int i;

  crash=0;
  shoot=0;
#ifdef DEBUG
  repetetive=1;
#else
  repetetive=0;
#endif
  refueling=0;
  speedx=0;
  speedy=0;
  absspeed=0L;
  oldabs=0L;
  vx=0;
  vy=0;
  if(round&1) {
    kdir=72;
    dir=24;
    gravity=-20;
    alpha=768;
    deltaalpha=0;
  }
  else {
    kdir=24;
    dir=8;
    gravity=20;
    alpha=256;
    deltaalpha=0;
  }
  if(reset) {
    loaded=0;
    loadcontact=0;
    loadpoint=0;
    loadpointshift=0;
    shipdx=0;
    shipdy=0;
  }
  else {
    loadcontact=0;
    if(loaded) {
      loadpoint=126;
      loadpointshift=0;
      shipdx=(sinus2[(alpha+256)&1023]*loadpoint)/1512;
      shipdy=(-sinus2[alpha]*loadpoint)/1512;
    }
    else {
      loadpoint=0;
      loadpointshift=0;
      *(bana+lenx*loadby+loadbx)=109;
      shipdx=0;
      shipdy=0;
    }
  }
  
  pblockx=xblock;
  pblocky=yblock+4*(round&1);
  if(loaded) {
    if(round&1)
      pblocky-=2;
    else
      pblocky+=2;
  }

  pixx=pblockx<<3;
  pixy=pblocky<<3;
  x=pixx<<3;
  y=pixy<<3;
  bildx=(pixx+PBILDX-4)%PBILDX+4;
  bildy=pixy%PBILDY;
  bblockx=bildx>>3;
  bblocky=bildy>>3;

  countdown=0;

  for(i=0; i<maxbullets; i++)
    bullets[i].life=0;

  chcolor=20;
  chpaper=0;
  chflag=0;
}

void
restorehardware()
{
  printf("Releasing keyboard...");
  keyboard_close();
  printf("done.\n");
  printf("Restoring textmode...");
  vga_setmode(TEXT);
  printf("done.\n");
}

void
restoremem()
{
  printf("Freeing allocated memory...");
  free(bild);
  free(bana);
  free(bulletmap);
  free(ship);
  free(shieldship);
  free(shipstorage);
  free(bulletstorage);
  free(fuelmap);
  free(fuelstorage);
  free(loadmap);
  free(loadstorage);
  printf("done.\n");
}
