
/* Written by Peter Ekberg, peda@lysator.liu.se */

#include <unistd.h>
#include <stdio.h>
#include <vga.h>
#include <vgakeyboard.h>
#include <linux/keyboard.h>
#include "thrust.h"

int scancode[5] = {
  SCANCODE_A,
  SCANCODE_S,
  SCANCODE_RIGHTCONTROL,
  SCANCODE_ENTER,
  SCANCODE_SPACE
};

/* All unknown keys are unknown since different keyboards have different
   keys at these scancodes. It would be nice if there were existed some
   library routine to map a scancode to a character. I havn't researched
   this, so this routing might exist without me knowing it. */

char *keynames[NR_KEYS] = {
  "NOT AVAILABLE",
  "ESCAPE",            /*   1 */
  "1",                 /*   2 */
  "2",
  "3",
  "4",
  "5",
  "6",
  "7",
  "8",
  "9",
  "0",                 /*  11 */
  "UNKNOWN",
  "UNKNOWN",
  "BACKSPACE",         /*  14 */
  "TAB",               /*  15 */
  "Q",                 /*  16 */
  "W",
  "E",
  "R",
  "T",
  "Y",
  "U",
  "I",
  "O",
  "P",                 /*  25 */
  "UNKNOWN",
  "UNKNOWN",
  "ENTER",             /*  28 */
  "LEFT CONTROL",      /*  29 */
  "A",                 /*  30 */
  "S",
  "D",
  "F",
  "G",
  "H",
  "J",
  "K",
  "L",                 /*  38 */
  "UNKNOWN",
  "UNKNOWN",
  "UNKNOWN",
  "LEFT SHIFT",        /*  42 */
  "UNKNOWN",
  "Z",                 /*  44 */
  "X",
  "C",
  "V",
  "B",
  "N",
  "M",                 /*  50 */
  "UNKNOWN",
  "UNKNOWN",
  "UNKNOWN",
  "RIGHT SHIFT",       /*  54 */
  "UNKNOWN",
  "LEFT ALT",          /*  56 */
  "SPACE",             /*  57 */
  "CAPS LOCK",         /*  58 */
  "F1",                /*  59 */
  "F2",
  "F3",
  "F4",
  "F5",
  "F6",
  "F7",
  "F8",
  "F9",
  "F10",               /*  68 */
  "NUM LOCK",          /*  69 */
  "SCROLL LOCK",       /*  70 */
  "KEYPAD HOME",       /*  71 */
  "KEYPAD UP",
  "KEYPAD PGUP",       /*  73 */
  "UNKNOWN",
  "KEYPAD LEFT",       /*  75 */
  "KEYPAD 5",
  "KEYPAD RIGHT",      /*  77 */
  "UNKNOWN",
  "KEYPAD END",        /*  79 */
  "KEYPAD DOWN",
  "KEYPAD PGDN",       /*  81 */
  "KEYPAD 0",          /*  82 */
  "KEYPAD DECIMAL",    /*  83 */
  "UNKNOWN",
  "UNKNOWN",
  "UNKNOWN",
  "F11",               /*  87 */
  "F12",               /*  88 */
  "UNKNOWN",
  "UNKNOWN",
  "UNKNOWN",
  "UNKNOWN",
  "UNKNOWN",
  "UNKNOWN",
  "UNKNOWN",
  "KEYPAD ENTER",      /*  96 */
  "RIGHT CONTROL",     /*  97 */
  "UNKNOWN",
  "PRINT SCREEN",      /*  99 */
  "RIGHT ALT",         /* 100 */
  "UNKNOWN",
  "HOME",              /* 102 */
  "CURSOR UP",         /* 103 */
  "PAGE UP",           /* 104 */
  "CURSOR LEFT",       /* 105 */
  "CURSOR RIGHT",      /* 106 */
  "END",               /* 107 */
  "CURSOR DOWN",       /* 108 */
  "PAGE DOWN",         /* 109 */
  "INSERT",            /* 110 */
  "DELETE"             /* 111 */
};

int keypressed(void)
{
  static char *state=NULL;
  int i;

  if(state==NULL)
    state=keyboard_getstate();

  for(i=0; i<NR_KEYS; i++)
    if(state[i])
      return(1);

  return(0);
}

int getscancode(int old, int x, int y)
{
  int i, result=0;
  static char str[40];
  char *keys;
  int oldcolor;

  keys=keyboard_getstate();
  oldcolor=chcolor;
  sprintf(str, "%s", keynames[old]);
  printgs(x, y, str);

  do {
    usleep(20000L);
    keyboard_update();
    for(i=0; i<NR_KEYS; i++) {
      if(keys[i]) {
	if(i>111)
	  i=0;
	chcolor=0;
	printgs(x, y, str);
	chcolor=oldcolor;
	sprintf(str, "%s", keynames[i==1?old:i]);
	printgs(x, y, str);
	result=i;
	i=NR_KEYS;
      }
    }
  } while(!result);
  
  return(result==1?old:result);
}

void
changekeys()
{
  static char *descriptions[5] = {
    "TURN LEFT",
    "TURN RIGHT",
    "THRUST",
    "FIRE",
    "PICKUP & FUEL"
  };
  int i, j, end;

  gcenter(45, "CHANGE KEYS");
  chcolor--;
  for(i=0; i<5; i++) {
    printgs(160-gstrlen(descriptions[i]), 65+i*8, descriptions[i]);
    printgs(161, 65+i*8, ":");
    printgs(167, 65+i*8, keynames[scancode[i]]);
  }
  gcenter(125, "PRESS ENTER TO CHANGE A KEY");
  gcenter(132, "(DON'T USE Q OR P, THESE ARE TAKEN)");
  gcenter(139, "USE CURSOR UP/DOWN TO MOVE AROUND");
  gcenter(148, "PRESS ESCAPE FOR THE MAIN MENU");

  i=0;
  end=0;
  chcolor++;
  printgs(160-gstrlen(descriptions[i]), 65+i*8, descriptions[i]);
  chcolor--;

  fade_in();

  do {
    do {
      usleep(20000L);
      keyboard_update();
    } while(!keypressed());

    if(keyboard_keypressed(SCANCODE_CURSORUP)
       || keyboard_keypressed(SCANCODE_CURSORBLOCKUP)) {
      printgs(160-gstrlen(descriptions[i]), 65+i*8, descriptions[i]);
      i=(i+4)%5;
    }

    if(keyboard_keypressed(SCANCODE_CURSORDOWN)
       || keyboard_keypressed(SCANCODE_CURSORBLOCKDOWN)) {
      printgs(160-gstrlen(descriptions[i]), 65+i*8, descriptions[i]);
      i=(i+1)%5;
    }

    if(keyboard_keypressed(SCANCODE_ENTER)
       || keyboard_keypressed(SCANCODE_KEYPADENTER)) {
      do {
	usleep(20000L);
	keyboard_update();
      } while(keypressed());
      printgs(160-gstrlen(descriptions[i]), 65+i*8, descriptions[i]);

      chcolor++;
      scancode[i]=getscancode(scancode[i], 167, 65+i*8);
      printgs(160-gstrlen(descriptions[i]), 65+i*8, descriptions[i]);
      chcolor--;

      printgs(167, 65+i*8, keynames[scancode[i]]);

      do {
	usleep(20000L);
	keyboard_update();
      } while(keypressed());
    }

    if(keyboard_keypressed(SCANCODE_ESCAPE)
       || keyboard_keypressed(SCANCODE_Q)) {
      end=1;
    }

    chcolor++;
    printgs(160-gstrlen(descriptions[i]), 65+i*8, descriptions[i]);
    chcolor--;

    for(j=0; j<15; j++) {
      usleep(10000L);
      keyboard_update();
      if(!keypressed())
	j=25;
    }
  } while(!end);
  
  do {
    usleep(20000L);
    keyboard_update();
  } while(keypressed());

  chcolor++;
  
  fade_out();
}
