/*
 * Programm XBLAST V1.2.9 or higher
 * (C) by Oliver Vogel (e-mail: vogel@ikp.uni-koeln.de)
 * February 24th
 * started August 1993
 *
 * File: shrink.h 
 * include file for shrink.c
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _SHRINK_H
#define _SHRINK_H

/*
 * constants
 */
#define SP_SW    0
#define SP_NW    1
#define SP_NE    2
#define SP_SE    3
#define SP_SW_NE 4
#define SP_NW_SE 5
#define SP_ALL   6

/*
 * prototypes
 */
#ifdef _SHRINK_C
#define _EXTERN 
#else
#define _EXTERN extern
#endif

#ifdef __STDC__
void shrink_void (void);
void shrink_spiral (void);
void shrink_speed_spiral (void);
void shrink_spiral_plus (void);
void shrink_spiral_3 (void);
void shrink_compound (void);
void shrink_compound_f (void);
void shrink_compound_2_f (void);
void shrink_lazy_compound_f (void);
void shrink_compound_solid (void);
void shrink_savage_compound (void);
void shrink_compound_extra (void);
void shrink_down (void);
void shrink_down_f (void);
void shrink_quad (void);
void shrink_constrict_wave (void);
void shrink_moving_blocks (void);
void init_shrink (int shrink_id);
void do_shrink (int game_time, int num_player, BMPlayer *ps);
void init_scramble (ScrambleStruct *draw, ScrambleStruct *del);
void do_scramble2 (int game_time, int num_player, BMPlayer *ps);
#else
void shrink_void ();
void shrink_spiral ();
void shrink_speed_spiral ();
void shrink_spiral_plus ();
void shrink_spiral_3 ();
void shrink_compound ();
void shrink_compound_f ();
void shrink_compound_2_f ();
void shrink_lazy_compound_f ();
void shrink_compound_solid ();
void shrink_savage_compound ();
void shrink_compound_extra ();
void shrink_down ();
void shrink_down_f ();
void shrink_quad ();
void shrink_constrict_wave ();
void shrink_moving_blocks ();
void init_shrink ();
void do_shrink ();
void init_scramble ();
void do_scramble2 ();
#endif

#undef _EXTERN 

#endif
/*
 * end of file shrink.h
 */








