
/*-
# X-BASED CUBES
#
#  xcubes.c
#
###
#
#  Copyright (c) 1994 - 96	David Albert Bagley, bagleyd@hertz.njit.edu
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/*-
  Version 4: 94/06/07 Xt
  Version 3: 93/04/01 Motif
  Version 2: 92/01/29 XView
  Version 1: 91/03/19 SunView
*/

#include <stdlib.h>
#include <stdio.h>
#ifdef VMS
#include <unixlib.h>
#define getlogin cuserid
#else
#ifndef apollo
#include <unistd.h>
#endif
#endif
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/cursorfont.h>
#include "Cubes.h"
#include "cubes.xbm"

#ifndef SCOREFILE
#define SCOREFILE "/usr/games/lib/cubes.scores"
#endif

/* The following is in CubesP.h also */
#define MINCUBES 1

#define MAXCUBES 8
#define MAXRECORD 32767
#define MAXPROGNAME 80
#define MAXNAME 256

static void Initialize(Widget w);
static void CallbackCubes(Widget w, caddr_t clientData, cubesCallbackStruct * callData);

static void PrintRecord(int sizeX, int sizeY, int sizeZ, char *record);
static int  HandleSolved(int counter, int sizeX, int sizeY, int sizeZ);
static void PrintState(Widget w, char *prog, int sizeX, int sizeY, int sizeZ,
		       int moves, char *record, char *message);
static void ReadRecords(void);
static void WriteRecords(void);

static Arg  arg[2];
static int  cubesRecord[MAXCUBES - MINCUBES + 1][MAXCUBES - MINCUBES + 1]
[MAXCUBES - MINCUBES + 1], movesDsp = 0;
static char progDsp[64] = "xcubes";
static char recordDsp[16] = "INF";
static char messageDsp[128] = "Welcome";
static char titleDsp[256] = "";

static void
Usage(void)
{
	(void) fprintf(stderr, "usage: xcubes\n");
	(void) fprintf(stderr,
	     "\t[-geometry [{width}][x{height}][{+-}{xoff}[{+-}{yoff}]]]\n");
	(void) fprintf(stderr,
		"\t[-display [{host}]:[{vs}]][-fg {color}] [-bg {color}]\n");
	(void) fprintf(stderr,
	 "\t[-brick {color}] [-{border|bd} {color}] [-size{x|y|z} {int}]\n");
	exit(1);
}

static XrmOptionDescRec options[] =
{
	{"-fg", "*cubes.Foreground", XrmoptionSepArg, NULL},
	{"-bg", "*Background", XrmoptionSepArg, NULL},
	{"-foreground", "*cubes.Foreground", XrmoptionSepArg, NULL},
	{"-background", "*Background", XrmoptionSepArg, NULL},
	{"-brick", "*cubes.brickColor", XrmoptionSepArg, NULL},
	{"-border", "*cubes.brickBorder", XrmoptionSepArg, NULL},
	{"-bd", "*cubes.brickBorder", XrmoptionSepArg, NULL},
	{"-sizex", "*cubes.sizeX", XrmoptionSepArg, NULL},
	{"-sizey", "*cubes.sizeY", XrmoptionSepArg, NULL},
	{"-sizez", "*cubes.sizeZ", XrmoptionSepArg, NULL},
};

int
main(int argc, char **argv)
{
	Widget      toplevel, cubes;

	toplevel = XtInitialize(argv[0], "Cubes",
				options, XtNumber(options), &argc, argv);
	if (argc != 1)
		Usage();

	XtSetArg(arg[0], XtNiconPixmap,
		 XCreateBitmapFromData(XtDisplay(toplevel),
				       RootWindowOfScreen(XtScreen(toplevel)),
			    (char *) cubes_bits, cubes_width, cubes_height));
	XtSetArg(arg[1], XtNinput, True);
	XtSetValues(toplevel, arg, 2);
	cubes = XtCreateManagedWidget("cubes", cubesWidgetClass, toplevel,
				      NULL, 0);
	XtAddCallback(cubes, XtNselectCallback, (XtCallbackProc) CallbackCubes,
		      (XtPointer) NULL);
	Initialize(cubes);
	XtRealizeWidget(toplevel);
	XGrabButton(XtDisplay(cubes), AnyButton, AnyModifier, XtWindow(cubes),
		TRUE, ButtonPressMask | ButtonMotionMask | ButtonReleaseMask,
		    GrabModeAsync, GrabModeAsync, XtWindow(cubes),
		    XCreateFontCursor(XtDisplay(cubes), XC_crosshair));
	XtMainLoop();

#ifdef VMS
	return 1;
#else
	return 0;
#endif
}

static void
Initialize(Widget w)
{
	int         sizeX, sizeY, sizeZ;

	XtVaSetValues(w,
		      XtNstart, FALSE,
		      NULL);
	XtVaGetValues(w,
		      XtNsizeX, &sizeX,
		      XtNsizeY, &sizeY,
		      XtNsizeZ, &sizeZ,
		      NULL);
	ReadRecords();
	PrintRecord(sizeX, sizeY, sizeZ, recordDsp);
	PrintState(XtParent(w), progDsp, sizeX, sizeY, sizeZ, movesDsp,
		   recordDsp, messageDsp);
}

static void
CallbackCubes(Widget w, caddr_t clientData, cubesCallbackStruct * callData)
{
	int         sizeX, sizeY, sizeZ;

	XtVaGetValues(w,
		      XtNsizeX, &sizeX,
		      XtNsizeY, &sizeY,
		      XtNsizeZ, &sizeZ,
		      NULL);
	(void) strcpy(messageDsp, "");
	switch (callData->reason) {
		case CUBES_RESTORE:
		case CUBES_RESET:
			movesDsp = 0;
			break;
		case CUBES_BLOCKED:
			(void) strcpy(messageDsp, "Blocked");
			break;
		case CUBES_SPACE:
			/*(void) strcpy(messageDsp, "Spaces can't move"); *//* Too annoying */
			break;
		case CUBES_IGNORE:
			(void) strcpy(messageDsp, "Randomize to start");
			break;
		case CUBES_MOVED:
			movesDsp++;
			XtSetArg(arg[0], XtNstart, TRUE);
			XtSetValues(w, arg, 1);
			break;
		case CUBES_SOLVED:
			if (HandleSolved(movesDsp, sizeX, sizeY, sizeZ))
				(void) sprintf(messageDsp, "Congratulations %s!!", getlogin());
			else
				(void) strcpy(messageDsp, "Solved!");
			XtSetArg(arg[0], XtNstart, FALSE);
			XtSetValues(w, arg, 1);
			break;
		case CUBES_RANDOMIZE:
			movesDsp = 0;
			XtSetArg(arg[0], XtNstart, FALSE);
			XtSetValues(w, arg, 1);
			break;
		case CUBES_DEC_X:
			movesDsp = 0;
			sizeX--;
			PrintRecord(sizeX, sizeY, sizeZ, recordDsp);
			XtSetArg(arg[0], XtNsizeX, sizeX);
			XtSetValues(w, arg, 1);
			break;
		case CUBES_INC_X:
			movesDsp = 0;
			sizeX++;
			PrintRecord(sizeX, sizeY, sizeZ, recordDsp);
			XtSetArg(arg[0], XtNsizeX, sizeX);
			XtSetValues(w, arg, 1);
			break;
		case CUBES_DEC_Y:
			movesDsp = 0;
			sizeY--;
			PrintRecord(sizeX, sizeY, sizeZ, recordDsp);
			XtSetArg(arg[0], XtNsizeY, sizeY);
			XtSetValues(w, arg, 1);
			break;
		case CUBES_INC_Y:
			movesDsp = 0;
			sizeY++;
			PrintRecord(sizeX, sizeY, sizeZ, recordDsp);
			XtSetArg(arg[0], XtNsizeY, sizeY);
			XtSetValues(w, arg, 1);
			break;
		case CUBES_DEC_Z:
			movesDsp = 0;
			sizeZ--;
			PrintRecord(sizeX, sizeY, sizeZ, recordDsp);
			XtSetArg(arg[0], XtNsizeZ, sizeZ);
			XtSetValues(w, arg, 1);
			break;
		case CUBES_INC_Z:
			movesDsp = 0;
			sizeZ++;
			PrintRecord(sizeX, sizeY, sizeZ, recordDsp);
			XtSetArg(arg[0], XtNsizeZ, sizeZ);
			XtSetValues(w, arg, 1);
			break;
		case CUBES_COMPUTED:
			XtSetArg(arg[0], XtNstart, FALSE);
			XtSetValues(w, arg, 1);
			break;
		case CUBES_UNDO:
			movesDsp--;
			XtSetArg(arg[0], XtNstart, TRUE);
			XtSetValues(w, arg, 1);
			break;
	}
	PrintState(XtParent(w), progDsp, sizeX, sizeY, sizeZ, movesDsp,
		   recordDsp, messageDsp);
}

static void
PrintRecord(int sizeX, int sizeY, int sizeZ, char *record)
{
	int         i = sizeX - MINCUBES, j = sizeY - MINCUBES, k = sizeZ - MINCUBES;

	if (sizeX > MAXCUBES || sizeY > MAXCUBES || sizeZ > MAXCUBES)
		(void) strcpy(record, "NOT RECORDED");
	else if (cubesRecord[i][j][k] >= MAXRECORD)
		(void) strcpy(record, "NEVER");
	else
		(void) sprintf(record, "%d", cubesRecord[i][j][k]);
}

static int
HandleSolved(int counter, int sizeX, int sizeY, int sizeZ)
{
	int         i = sizeX - MINCUBES, j = sizeY - MINCUBES, k = sizeZ - MINCUBES;

	if (sizeX <= MAXCUBES && sizeY <= MAXCUBES && sizeZ <= MAXCUBES &&
	    counter < cubesRecord[i][j][k]) {
		cubesRecord[i][j][k] = cubesRecord[i][k][j] = cubesRecord[j][i][k] =
			cubesRecord[j][k][i] = cubesRecord[k][i][j] = cubesRecord[k][j][i] =
			counter;
		WriteRecords();
		(void) sprintf(recordDsp, "%d", counter);
		return TRUE;
	}
	return FALSE;
}

static void
PrintState(Widget w, char *prog, int sizeX, int sizeY, int sizeZ, int moves, char *record, char *message)
{
	(void) sprintf(titleDsp, "%s: %dx%dx%d@ (%d/%s) - %s",
		       prog, sizeX, sizeY, sizeZ, moves, record, message);
	XtSetArg(arg[0], XtNtitle, titleDsp);
	XtSetValues(w, arg, 1);
}

static void
ReadRecords(void)
{
	FILE       *fp;
	int         i, j, k, n;

	for (i = 0; i < MAXCUBES - MINCUBES + 1; i++)
		for (j = i; j < MAXCUBES - MINCUBES + 1; j++)
			for (k = j; k < MAXCUBES - MINCUBES + 1; k++)
				cubesRecord[k][j][i] = cubesRecord[k][i][j] =
					cubesRecord[j][k][i] = cubesRecord[j][i][k] =
					cubesRecord[i][k][j] = cubesRecord[i][j][k] = MAXRECORD;
	if ((fp = fopen(SCOREFILE, "r")) == NULL)
		(void) sprintf(messageDsp, "Can not open %s, taking defaults.", SCOREFILE);
	else {
		for (i = 0; i < MAXCUBES - MINCUBES + 1; i++)
			for (j = i; j < MAXCUBES - MINCUBES + 1; j++)
				for (k = j; k < MAXCUBES - MINCUBES + 1; k++) {
					(void) fscanf(fp, "%d", &n);
					cubesRecord[k][j][i] = cubesRecord[k][i][j] =
						cubesRecord[j][k][i] = cubesRecord[j][i][k] =
						cubesRecord[i][k][j] = cubesRecord[i][j][k] = n;
				}
		(void) fclose(fp);
	}
}

static void
WriteRecords(void)
{
	FILE       *fp;
	int         i, j, k;

	if ((fp = fopen(SCOREFILE, "w")) == NULL)
		(void) sprintf(messageDsp, "Can not write to %s.", SCOREFILE);
	else {
		for (i = 0; i < MAXCUBES - MINCUBES + 1; i++) {
			for (j = i; j < MAXCUBES - MINCUBES + 1; j++) {
				for (k = j; k < MAXCUBES - MINCUBES + 1; k++)
					(void) fprintf(fp, "%d ", cubesRecord[i][j][k]);
				(void) fprintf(fp, "\n");
			}
			(void) fprintf(fp, "\n");
		}
		(void) fclose(fp);
	}
}
