# include <stdio.h>
# include <stdlib.h>
# include <fcntl.h>

# include "hfs.h"
# include "hcwd.h"
# include "hfsutil.h"
# include "glob.h"
# include "hmkdir.h"

/*
 * NAME:	hmkdir->main()
 * DESCRIPTION:	implement hmkdir command
 */
int hmkdir_main(int argc, char *argv[])
{
  hfsvol *vol;
  char **fargv;
  int fargc, i, result = 0;

  if (argc < 2)
    {
      fprintf(stderr, "Usage: %s hfs-path [...]\n", argv[0]);
      return 1;
    }

  vol = hfs_remount(hcwd_getvol(-1), O_RDWR);
  if (vol == 0)
    return 1;

  fargv = hfs_glob(vol, argc - 1, &argv[1], &fargc);
  if (fargv == 0)
    {
      fprintf(stderr, "%s: out of memory\n", argv[0]);
      result = 1;
    }
  else
    {
      for (i = 0; i < fargc; ++i)
	{
	  if (hfs_mkdir(vol, fargv[i]) < 0)
	    {
	      hfs_perrorp(fargv[i]);
	      result = 1;
	    }
	}
    }

  if (hfs_umount(vol) < 0 && result == 0)
    {
      hfs_perror("Error closing HFS volume");
      result = 1;
    }

  if (fargv)
    free(fargv);

  return result;
}
