
#include <OffiX/DragAndDrop.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Command.h>
#include <stdio.h>

XtAppContext app;

void DropEventHandler(Widget,XtPointer,XEvent*,Boolean*);
void DragEventHandler(Widget,XtPointer,XEvent*,Boolean*);

int
main(int argc, char* argv[])
{
	Widget toplevel, button;
	
	toplevel=XtVaAppInitialize(&app,"Test1",NULL,0,
				   (Cardinal*)&argc,argv,
				   NULL,NULL);
	
	DndInitialize(toplevel);
	
	button=XtVaCreateManagedWidget("Button",
				       commandWidgetClass, toplevel,
				       XtNlabel, "Drag And Drop Test 1",
				       NULL);
	
	DndRegisterDragWidget(button,DragEventHandler,(XtPointer)argv);
	DndRegisterDropWidget(button,DropEventHandler,(XtPointer)argv);
	
	XtRealizeWidget(toplevel);
	XtAppMainLoop(app);
	return 0;		
}

void DropEventHandler(Widget widget,XtPointer data,XEvent* event,Boolean* b)
{
	fprintf(stderr,"Dropped on test 1 !\n");
}

void DragEventHandler(Widget widget,XtPointer data,XEvent* event,Boolean* b)
{
	fprintf(stderr,"Test 1 Drag event handler.\n");
	DndHandleDragging(widget,event);
}
