
#include <stdio.h>
#include <qpushbt.h>
#include "awaymsgdlg.h"


AwayMsgDlg::AwayMsgDlg(ICQOwner *theOwner, QWidget *parent = 0, const char *name = 0) : QDialog(parent, name)
{
   owner = theOwner;
   resize(300, 100);
   mleAwayMsg = new MLEditWrap(true, this);
   mleAwayMsg->setGeometry(5, 5, 290, 50);
   QPushButton *btnOk, *cancel;
   btnOk = new QPushButton( "Ok", this );
   btnOk->setGeometry(10, 60, 100, 30 );
   connect( btnOk, SIGNAL(clicked()), SLOT(ok()) );
   cancel = new QPushButton( "Cancel", this );
   cancel->setGeometry( 120, 60, 100, 30 );
   connect( cancel, SIGNAL(clicked()), SLOT(reject()) );
}


void AwayMsgDlg::show()
{
   char title[128];
   sprintf(title, "Set Away Message for %s:", owner->alias());
   setCaption(title);
   mleAwayMsg->setText(owner->awayMessage());
   QDialog::show();
}


void AwayMsgDlg::ok()
{
   char msg[4096];
   sprintf(msg, "%s", (const char *)mleAwayMsg->text()); 
   owner->setAwayMessage(msg);
   accept();
}
