#ifndef file_h
#define file_h

#include <stdio.h>
//#include <stdlib.h>

class File
{
     public:
	 File(char *fname, bool allowCreate = false);
	 ~File(void);
    bool error(void);
	 bool read(char *val, bool fatal = false, bool noisy = true);
	 bool read(unsigned short &val, bool fatal = false, bool noisy = true);
    bool read(unsigned long  &val, bool fatal = false, bool noisy = true);
    bool read(bool &val, bool fatal = false, bool noisy = true);
	 void write(char *val);
	 void write(unsigned short val);
	 void write(unsigned long  val);
    void write(bool val);
	 void clear(void);
	 void delSect(char *name);
	 void delKey(char *name);
	 File& section(char *s);
	 File& key(char *s);
protected:
	 void reset(void);
	 void nextKey(void);
	 int  readLine(void);
	 void nextSect(void);
	 bool fillToTarget(char *&buff);
	 void fillToEof(char *&buff);
	 void replace(char *s);
	 void processLine(void);
	 void buffToFile(char *from, char *to);
	 char *filename;
	 char targetSect[80];
	 char targetKey[80];
	 FILE *file;
	 bool eof, errorVal;
	 struct
	 {
	    char sect[80];
	    char key[80];
	    char keyVal[80];
	    char line[80];
	 } currentEntry;
};

#endif
