#ifndef LicqGUI_included
#define LicqGUI_included

#include <qapp.h>
#include <qwidget.h>
#include <qcombo.h>
#include <qmenubar.h>
#include <qpopmenu.h>
#include <qlistbox.h>
#include <qgrpbox.h>
#include <qtimer.h>
#include <qtimer.h>
//#include <qsplitter.h>

#include "icq.h"
#include "outputwin.h"
#include "icqfunctions.h"
#include "userbox.h"
#include "awaymsgdlg.h"
#include "adduserdlg.h"
#include "authuserdlg.h"
#include "searchuserdlg.h"
#include "chatdlg.h"
#include "optionsdlg.h"


class NewLabel : public QLabel
{
   Q_OBJECT
public:
   NewLabel(QPopupMenu *m = NULL, QWidget *parent = 0, char *name = 0);
   void setBold(bool);
   void setItalic(bool);
   void setNamedColor(char *);
protected:
   virtual void mouseDoubleClickEvent(QMouseEvent *);
   virtual void mouseReleaseEvent(QMouseEvent *e);
   QPopupMenu *mnuPopUp;
signals:
   void doubleClicked();
};


//=====LicqGUI=====================================================================================
class LicqGUI: public QWidget
{
   Q_OBJECT
public:
   LicqGUI(ICQ *theServer, QWidget *parent = 0, const char *name = 0);
   ~LicqGUI(void);
protected:
   ICQ *server;
   OutputWin *netWin;
   AwayMsgDlg *awayMsgDlg;
   AddUserDlg *addUserDlg;
   AuthUserDlg *authUserDlg;
   SearchUserDlg *searchUserDlg;
   ChatDlg *chatDlg;
   OptionsDlg *optionsDlg;
   //ICQFunctions *icqFunctions;
   //UserView *userViewOnline, *userViewOffline;
   //QSplitter *splUser;
   UserView *userView;
   QMenuBar *menu;
   QPopupMenu *mnuFile, *mnuUser, *mnuUserAdm, *mnuStatus, *mnuDebug;
   QGroupBox *statusBar;
   NewLabel *lblStatus, *lblSysMsg, *lblMsg;
   char fontFamily[32], pmBgName[128],
        colorOnline[32], colorAway[32], colorOffline[32], colorNew[32], 
        colorBackground[32];
   unsigned short fontCharSetInt;
   QPixmap *pmOnline, *pmOffline, *pmAway, *pmDnd, *pmOccupied, *pmNa, *pmPrivate, *pmMessage;
   unsigned short fontSize;
   vector <ColInfo> colInfo;
   QTimer autoAwayTimer;
   unsigned short autoAwayTime, autoNATime, manualAway;
   bool inMiniMode, gridLines, showHeader, autoClose;

   void resizeEvent (QResizeEvent *);
   void callICQFunction(int fcn, bool isUser);
   
protected slots:
   void removeUser();
   void updateUserWin();
   void updateStatus();
   void changeStatus(int index);
   void changeStatusManual(int index);
   void callDefaultICQFunction();
   void callICQOwnerFunction();
   void callICQUserFunction(int fcn);
   void killICQFunction(ICQUser *);
   void eventResult(ICQUser *, unsigned short, bool, unsigned long);
   void done(bool isOk, unsigned short cmd);
   void showOptions();
   void getOptions();
   void saveOptions();
   void changeDebug(int);
   //void toggleAutoClose();
   //void toggleGridLines();
   //void toggleHeader();
   //void changeSound(int);
   void miniMode();
   void nextServer();
   void autoAway();
   void aboutBox();

signals:
   void changeDockStatus(unsigned short int);

};


#endif
