#include <qpainter.h>
#include <qheader.h>
#include <qkeycode.h>
#include <math.h>
#include "userbox.h"

UserViewItem::UserViewItem(ICQUser *u, unsigned short theIndex, QPixmap *p, const QColor &theColor, const QColor &theBackColor, bool isGridLines, QListView *parent) : QListViewItem(parent), lineColor(theColor), backColor(theBackColor)
{ 
   pm = p; // this saves memory but relies on you not deleting the pixmap  //(p == NULL ? NULL : new QPixmap(*p));
   user = u;
   index = theIndex;
   gridLines = isGridLines;
   if (pm != NULL) setPixmap(0, *pm);
   struct UserStatusline us;
   user->getStatusInfo(us);
   for (unsigned short i = 0; i < ((UserView *)listView())->colInfo.size(); i++) 
   {
      switch (((UserView *)listView())->colInfo[i].info) 
      {
      case COL_ALIAS:
         setText(i + 1, us.alias);
         break;
      case COL_UIN:
         setText(i + 1, us.uin);
         break;
      case COL_NAME:
         setText(i + 1, us.name);
         break;
      case COL_EMAIL:
         setText(i + 1, us.email);
         break;
      }
   }
}


void UserViewItem::paintCell( QPainter * p, const QColorGroup & cg, int column, int width, int align )
{
   QFont newFont(p->font());
   newFont.setBold(user->numMessages() > 0);
   p->setFont(newFont);

   QListViewItem::paintCell(p, QColorGroup(cg.foreground(), cg.background(), cg.light(), cg.dark(), cg.mid(), lineColor, backColor), column, width, align);
   
   // add line to bottom and right side
   if (gridLines) 
   {
      p->setPen(cg.mid());
      p->drawLine(0, height() - 1, width - 1, height() - 1);
      p->drawLine(width - 1, 0, width - 1, height() - 1);
   }
}


const char *UserViewItem::key (int column, bool ascending) const
{
   static char tmpString[64];

   if (column == 0) 
   {
      sprintf(tmpString, "%09d", index);
   }
   else if (column == 2) 
   {
      sprintf(tmpString, "%09ld", user->uin());
   } 
   else 
   {
      sprintf(tmpString, "%s", QListViewItem::key(column, ascending));
   }
   return (tmpString);

}



//-----UserList::constructor-----------------------------------------------------------------------
/*UserView::UserView (QPopupMenu *m, QColor &theOnColor, QColor &theAwayColor, QColor &theOffColor, 
                    QColor &theOnBackground, QColor &theAwayBackground, QColor &theOffBackground,
                    QWidget *parent = 0, const char *name = 0) 
                    : QListView(parent, name), clrOnline(theOnColor), clrAway(theAwayColor), clrOffline(theOffColor),
                      clrOnlineBack(theOnBackground), clrAwayBack(theAwayBackground), clrOfflineBack(theOffBackground)*/
UserView::UserView (QPopupMenu *m, vector <ColInfo> theColInfo, bool isHeader, QWidget *parent = 0, const char *name = 0) : QListView(parent, name)
{
   mnuUser = m;
   colInfo = theColInfo;
   
   addColumn("S", 20);
   for (unsigned short i = 0; i < colInfo.size(); i++) 
   {
      switch (theColInfo[i].info) 
      {
      case COL_ALIAS:
         addColumn("Alias", colInfo[i].width);
         break;
      case COL_UIN:
         addColumn("UIN", colInfo[i].width);
         break;
      case COL_NAME:
         addColumn("Name", colInfo[i].width);
         break;
      case COL_EMAIL:
         addColumn("EMail Address", colInfo[i].width);
         break;
      }
      setColumnAlignment(i + 1, pow(2, colInfo[i].align));
   }
   setAllColumnsShowFocus (true); 

   QPalette pal(palette());
   QColorGroup normal(pal.normal());
   QColorGroup newNormal(normal.foreground(), normal.background(), normal.light(), normal.dark(),
                         normal.mid(), normal.text(), QColor(194, 194, 194));
   setPalette(QPalette(newNormal, pal.disabled(), newNormal));
   setFrameStyle(QFrame::Panel | QFrame::Sunken);
   
   showHeader(isHeader);
}


void UserView::showHeader(bool isHeader)
{
   QHeader *h = CHILD(this, QHeader, "list view header");
   if (!isHeader) h->hide();
   else h->show();
}


ICQUser *UserView::currentUser(void)
{
   if (currentItem() == NULL) return (NULL);
   return (((UserViewItem *)currentItem())->user);
}


//-----UserList::mouseReleaseEvent-----------------------------------------------------------------
void UserView::mouseReleaseEvent(QMouseEvent *e)
{
   QListView::mouseReleaseEvent(e);
   if (e->button() == RightButton) 
   {
      QPoint clickPoint(e->x(), e->y());
      QListViewItem *clickedItem = itemAt(clickPoint);
      if (clickedItem != NULL) 
      {
         setSelected(clickedItem, true);
         setCurrentItem(clickedItem);
         mnuUser->popup(mapToGlobal(clickPoint));
      }
   }
}



void UserView::keyPressEvent(QKeyEvent *e)
{
   // Space will popup the user menu over the current user
   if ( (e->key() == Key_Space) && mnuUser != NULL) 
   {
      cout << "hello" << endl;
      // Get the menu width (512 when not initialized; used sane value)
      int nMenuWidth = mnuUser->width();
      if ( 512 == nMenuWidth )
         nMenuWidth = 120;
      // Calculate where to position the menu
      const QListViewItem *pcItem = currentItem();
      QPoint cRelPos( (width() - nMenuWidth)/2,
                      itemPos(pcItem) + pcItem->height() );
      QPoint cPos( mapToGlobal( cRelPos ) );
      mnuUser->popup( cPos );
   }
   else 
   {
      QListView::keyPressEvent(e);
   }
}

