#ifndef LISTBOXITEM_H
#define LISTBOXITEM_H

#include <qlistview.h>
#include <qpopmenu.h>
#include <vector.h>

#include "user.h"

#define COL_ALIAS 1
#define COL_UIN 2
#define COL_NAME 3
#define COL_EMAIL 4

class ColInfo
{
public:
   ColInfo(unsigned theInfo = 0, unsigned short theWidth = 0, unsigned short theAlign = 0)
      { info = theInfo; width = theWidth; align = (unsigned short)theAlign; };
   unsigned short info, width, align;
};


//=====UserViewItem================================================================================
class UserViewItem : public QListViewItem
{
public:
   UserViewItem (ICQUser *, unsigned short, QPixmap *, const QColor &, const QColor &, bool, QListView *);
   virtual const char *key (int column, bool ascending) const;

protected:
   virtual void paintCell ( QPainter *, const QColorGroup &, int column, int width, int align);
   
   QColor lineColor, backColor;
   QPixmap *pm;
   ICQUser *user;
   unsigned short index;
   bool gridLines;

friend class UserView;
};


//=====UserView====================================================================================
class UserView : public QListView
{
public:
   //UserView (QPopupMenu *m, QColor &, QColor &, QColor &, QColor &, QColor &, QColor &, QWidget *parent = 0, const char *name = 0);
   UserView (QPopupMenu *m, vector <ColInfo> colInfo, bool isHeader, QWidget *parent = 0, const char *name = 0);
   void showHeader(bool);
   ICQUser *currentUser(void);
   //QColor clrOnline, clrOffline, clrAway, clrOnlineBack, clrAwayBack, clrOfflineBack;
   vector <ColInfo> colInfo;
protected:
   QPopupMenu *mnuUser;
   void mouseReleaseEvent(QMouseEvent *e); 
   void keyPressEvent(QKeyEvent *e);
};


#endif
