/*
  Copyright (C) 1997,1998  Dimitrios P. Bouras

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   For author contact information, look in the README file.
*/

/* Constants relevant to the PTT data structures */

#define MAXNUM_PTT      24	/* known PPT's for call cost calculation */
#define MAXLEN_PTTNAME  32	/* characters reserved for PTT name */
#define MAXLEN_CURRENCY 16	/* max length of national currency name */
#define MAXNUM_ZONES    16	/* maximum number of price zones for a PTT */
#define MAXLEN_ZNAME    48	/* characters reserved for zone description */
#define MAXNUM_CATEGORY 64	/* maximum number of categories within each zone */

#define MAXVAL_MINUNITS		32		/* max value of minimum units */
#define MAXVAL_MINCOST		100000	/* max value of minimum cost */
#define MAXVAL_COSTQUANTUM	10000	/* max value of cost quantum */
#define MAXNUM_DECIMALS		3		/* max number of decimals for printouts */
#define MAXVAL_TARIFF		100000	/* maximum tariff value */
#define MAXSEC_MINCOSTLEN	3600	/* max seconds of minimum cost length */
#define MINVAL_RELDATE		-300	/* relative date minimun value */
#define MAXVAL_RELDATE		+300	/* relative date maximun value */

/* Identifiers for the known PTT's */

#define PTT_AT			0	/* Oesterreichische Telekom, Austria */
#define PTT_BE			1	/* BelgaCom, Belgium */
#define PTT_BT          2	/* British Telecom, United Kingdom */
#define PTT_CAMBRIDGE	3	/* Cambridge Cable Phone Company, Cambridge, UK */
#define PTT_CH			4	/* Swiss PTT */
#define PTT_CZ			5	/* SPT TELECOM, a.s., CZ */
#define PTT_DT			6	/* Deutsche Telekom A.G., Germany */
#define PTT_ES			7	/* Telefnica de Espaa, Spain */
#define PTT_FT			8	/* France Telekom, France */
#define PTT_GR			9	/* OTE A.E., Hellas */
#define PTT_IT			10	/* Italian PTT */
#define PTT_MATAV		11	/* MATAV, Hungary */
#define PTT_NL			12	/* Dutch PTT, the Netherlands */
#define PTT_NTT			13	/* NTT, Japan */
#define PTT_PL			14	/* Telekom. Polska S.A., Poland */
#define PTT_PT			15	/* Portuguese PTT */
#define PTT_SAT			16	/* Telkom, South Africa */
#define PTT_SIT			17	/* Slovene Telekom */
#define PTT_TDK			18	/* TeleDanmark, Denmark */
#define PTT_CARNET		19	/* CARNet, Croatia */
#define PTT_HPT			20	/* HPT, Croatia */
#define PTT_HPY			21	/* HPY, Helsinki Telephone Corp. */
#define PTT_TELENOR		22	/* Telenor, Norway */
#define PTT_NETCOLOGNE	23	/* Netcologne GmbH, Germany */

/* PTT attribute masks */

#define PTT_BY_UNIT			0x01
#define PTT_PER_MINUTE		0x02
#define PTT_PER_SECS		0x04
#define PTT_CUR_AFTER_COST	0x08
#define PTT_NONLINEAR_MIN	0x10

/* Rule types (possible 0-3F) and type flags */

#define RULE_DEFAULT			0
#define RULE_WEEKALL			1
#define RULE_WEEKDAY			2
#define RULE_SATURDAY			3
#define RULE_SUNDAY				4
#define RULE_WEEKEND			5
#define RULE_RHOLIDAY			6
#define RULE_AHOLIDAY			7
#define RULE_SPECIAL_WEEKDAY	8
#define RULE_SPECIAL_WEEKEND	9
#define DISCOUNT_PERMITTED		0x40
#define DEFEAT_MIN_TIME_LEN		0x80

/* The PTT information data structures */

typedef struct ruledate_struct {
	unsigned char mon;				/* month field */
	unsigned char day;				/* day field */
} ruledate_t;

typedef struct ruletime_struct {
	unsigned char h;				/* hour field */
	unsigned char m;				/* minute field */
	unsigned char s;				/* second field */
} ruletime_t;

typedef struct rule_struct {
	unsigned char type;				/* rule type */
	ruledate_t adate;				/* absolute or starting date */
	ruledate_t edate;				/* end date for date ranges */
	int rdate;						/* date relative to Easter Sunday */
	ruletime_t start;				/* rule start time */
	ruletime_t end;					/* rule end time */
	float tariff;					/* rule tariff */
} rule_t;

typedef struct discount_struct {
	float percent;					/* discount percentage */
	ruletime_t start;				/* discount exclusion interval */
	ruletime_t end;					/* start and end times */
} discount_t;

typedef struct ptt_struct {
	char name[MAXLEN_PTTNAME+1];				  /* the PTT name string */
	unsigned char num_zones;					  /* # of charging zones */
	unsigned char current_zone;					  /* currently selected zone */
	unsigned char num_categories;				  /* # of tariff rules/zone */
	unsigned int attribs;						  /* PTT attributes */
	unsigned char min_units;					  /* minimum units charged */
	float min_cost;								  /* minimum cost charged */
	unsigned char charge_period;				  /* time charging period */
	float cost_quantum;							  /* sec/unit or cost/minute */
	char currency[MAXLEN_CURRENCY+1];			  /* local currency string */
	unsigned char decimals;						  /* decimals for printouts */
	float dflt_tariff[MAXNUM_ZONES];			  /* zone default tariffs */
	unsigned int min_cost_len[MAXNUM_ZONES];	  /* min-cost length in sec */
	char zone_name[MAXNUM_ZONES][MAXLEN_ZNAME+1]; /* zone names */
	discount_t discount[MAXNUM_ZONES];			  /* special zone discount */
	rule_t rule[MAXNUM_ZONES][MAXNUM_CATEGORY];   /* zone tariff rules */
} ptt_t;

#define PTT_DEFAULT {{0}, 0, 0, 0, PTT_BY_UNIT, 0, 0.0, 60, 0.0, \
					 {0}, 0, {0.0}, {0}, {{0}}, {{0.0,{0,0,0},{24,0,0}}}, \
					 {{{RULE_WEEKALL,{0,1},{11,31},0,{0,0,0},{24,0,0},0.0}}}}

typedef struct xispPTTs_struct {
	
} xispPTTs_t;

/* Module interface routines */

int initLogFnames(glob_t *global);
void logs_init(glob_t *global, char *logdirname,
			   char *costfname, char *logfname, char *pttfname);
void costCalcReset(ptt_t *ptt, time_t upTime);
float callCost(ptt_t* ptt, unsigned long onLineSecs,
			   unsigned long *onLineUnits);
void readXispCost(unsigned long *totalTime, unsigned long *totalUnits);
#define restartXispCost(a,b) readXispCost(a,b)
void writeXispCost(unsigned long totalTime, unsigned long totalUnits);
void writeXispLog(int up, ptt_t *ptt, char *ts, char *ISPn, char *IPs,
				  unsigned long onLineSecs, float onLineCost,
				  unsigned long pTXed, unsigned long pRXed);
int buildStats(glob_t *global, unsigned int *current,
			   unsigned long *tblTime, unsigned long *tblUnits);
void initXispPTT(ptt_t *);
void readXispPTTs(ptt_t **pttdataptr, glob_t *global);
void writeXispPTTs(ptt_t *pttdata, glob_t *global);

